/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.sample.trader;

import java.net.SocketException;
import java.util.Iterator;
import java.util.Map;
import org.apache.sandesha2.client.SandeshaClientConstants;
import org.wso2.utils.NetworkUtils;
import org.wso2.wsas.ServerManager;
import org.wso2.wsas.sample.exchange.trader.ExchangeTraderStub;
import org.wso2.wsas.sample.trader.ClientDetails;
import org.wso2.wsas.sample.trader.SymbolTable;
import org.wso2.wsas.sample.utils.Utils;
import org.wso2.www.types.exchange.trader.BuyRequest;
import org.wso2.www.types.exchange.trader.ClientInfo;
import org.wso2.www.types.exchange.trader.RegisterClientRequest;
import org.wso2.www.types.exchange.trader.RegisterClientResponse;
import org.wso2.www.types.exchange.trader.SellRequest;
import org.wso2.www.types.trader.client.service.StockQuote;

public class Trader {
    public static final String EXCHANGE_SERVICE_ENDPORT_ADDRESS = "exchangeEndpointAddress";
    private static Trader ourInstance;
    private String myEPR = "http://127.0.0.1:9762/services/TraderClient";
    private String exchangeEPR = "http://127.0.0.1:9762/services/ExchangeTrader";
    private Map stockMarket = Utils.getPrePopulatedStockMarket("TraderClient");
    private Map clientDetails = Utils.getPrePopulatedClientList();

    private Trader() {
    }

    public static Trader getInstance() {
        if (ourInstance == null) {
            ourInstance = new Trader();
        }
        return ourInstance;
    }

    public void setExchangeEPR(String serviceContextPath) throws SocketException {
        this.exchangeEPR = "http://" + NetworkUtils.getLocalHostname() + ":" + ServerManager.getInstance().getHttpPort() + serviceContextPath + "/ExchangeTrader";
    }

    public void setExchangeEPR(String serviceContextPath, String serviceName) throws SocketException {
        this.exchangeEPR = "http://" + NetworkUtils.getLocalHostname() + ":" + ServerManager.getInstance().getHttpPort() + serviceContextPath + "/" + serviceName;
    }

    public Trader createTraderWithExchangeEPR(String serviceContextPath) throws SocketException {
        ourInstance.setExchangeEPR(serviceContextPath);
        return ourInstance;
    }

    public Trader createTraderWithExchangeEPR(String serviceContextPath, String serviceName) throws SocketException {
        ourInstance.setExchangeEPR(serviceContextPath, serviceName);
        return ourInstance;
    }

    public void updateInformation(String symbol, Float price) {
        if (symbol != null && SymbolTable.getInstance().isSymbolAvailable(symbol)) {
            this.stockMarket.put(symbol, price);
        }
    }

    public StockQuote getQuote(String symbol) {
        StockQuote stockQuote = (StockQuote)this.stockMarket.get(symbol);
        if (stockQuote == null) {
            stockQuote = new StockQuote();
            stockQuote.setName("No Symbol");
            stockQuote.setSymbol(symbol);
            stockQuote.setHigh(0.0f);
            stockQuote.setLow(0.0f);
            stockQuote.setPrice(0.0f);
        }
        return stockQuote;
    }

    public String[] getSymbols() {
        Iterator iterator = this.stockMarket.keySet().iterator();
        String[] symbols = new String[this.stockMarket.keySet().size()];
        int i = 0;
        while (iterator.hasNext()) {
            symbols[i++] = (String)iterator.next();
        }
        return symbols;
    }

    public void buy(String userName, String password, String symbol, int qty) throws Exception {
        float amountRequired;
        ClientDetails clientDetails = this.getClientDetails(userName, password);
        if (!SymbolTable.getInstance().isSymbolAvailable(symbol)) {
            throw new Exception("Symbol Not found");
        }
        StockQuote stocksDetails = (StockQuote)this.stockMarket.get(symbol);
        double credit = clientDetails.getCredit();
        if (credit < (double)(amountRequired = stocksDetails.getPrice() * (float)qty)) {
            throw new Exception("Not enough credit to complete transaction. Credit left = $" + credit + ".  Required amount = $" + amountRequired);
        }
        clientDetails.setCredit(credit - (double)amountRequired);
        Map stockHoldings = clientDetails.getStockHoldings();
        Integer stockHoldingsInt = (Integer)stockHoldings.get(symbol);
        if (stockHoldingsInt == null || stockHoldingsInt <= 0) {
            stockHoldings.put(symbol, new Integer(qty));
        } else {
            stockHoldings.put(symbol, new Integer(stockHoldingsInt + qty));
        }
        ExchangeTraderStub stubForExchange = new ExchangeTraderStub(this.exchangeEPR);
        stubForExchange._getServiceClient().getOptions().setProperty(SandeshaClientConstants.UNRELIABLE_MESSAGE, (Object)"true");
        BuyRequest buyReq = new BuyRequest();
        buyReq.setUserid(userName);
        buyReq.setSymbol(symbol);
        buyReq.setQty(qty);
        stubForExchange.buy(buyReq);
    }

    public void sell(String userName, String password, String symbol, int qty) throws Exception {
        ClientDetails clientDetails = this.getClientDetails(userName, password);
        Map stockHoldings = clientDetails.getStockHoldings();
        if (stockHoldings == null) {
            throw new Exception("No stock holdings for this user");
        }
        if (!SymbolTable.getInstance().isSymbolAvailable(symbol)) {
            throw new Exception("Symbol Not found");
        }
        Integer holdingsInt = (Integer)stockHoldings.get(symbol);
        if (holdingsInt == null || holdingsInt < qty) {
            throw new Exception("cannot sell more than you have. You have only " + (holdingsInt == null ? "0" : holdingsInt + " ") + ", but trying to sell " + qty);
        }
        stockHoldings.put(symbol, new Integer(holdingsInt - qty));
        ExchangeTraderStub stubForExchange = new ExchangeTraderStub(this.exchangeEPR);
        stubForExchange._getServiceClient().getOptions().setProperty(SandeshaClientConstants.UNRELIABLE_MESSAGE, (Object)"true");
        SellRequest sellReq = new SellRequest();
        sellReq.setUserid(userName);
        sellReq.setSymbol(password);
        sellReq.setQty(qty);
        stubForExchange.sell(sellReq);
    }

    public void depositMoney(String userName, String password, double amount) throws Exception {
        ClientDetails clientDetails = this.getClientDetails(userName, password);
        clientDetails.setCredit(clientDetails.getCredit() + amount);
    }

    public ClientDetails getClientDetails(String userName, String password) throws Exception {
        if (userName == null || password == null) {
            throw new Exception("Username and/or password is empty");
        }
        ClientDetails clientDetails = (ClientDetails)this.clientDetails.get(userName);
        if (clientDetails == null || !password.equals(clientDetails.getPassword())) {
            throw new Exception("Username cannot be found or password is wrong");
        }
        return clientDetails;
    }

    public String createUserAccount(String ssn, String name, String password) {
        try {
            if (this.clientDetails.get(name) != null) {
                throw new Exception("User already exists!");
            }
            this.clientDetails.put(name, new ClientDetails(ssn, name, password));
            ExchangeTraderStub stubForExchange = new ExchangeTraderStub(this.exchangeEPR);
            RegisterClientRequest regClientRequest = new RegisterClientRequest();
            ClientInfo clientInfo = new ClientInfo();
            clientInfo.setName(name);
            clientInfo.setSsn(ssn);
            regClientRequest.setClientInfo(clientInfo);
            stubForExchange._getServiceClient().getOptions().setProperty(SandeshaClientConstants.UNRELIABLE_MESSAGE, (Object)"true");
            RegisterClientResponse registerClientResponse = stubForExchange.registerClient(regClientRequest);
            return registerClientResponse.getUserid();
        }
        catch (Exception e) {
            e.printStackTrace();
            return e.getMessage();
        }
    }

    public Map getPortfolio(String userName, String password) throws Exception {
        ClientDetails clientDetails = this.getClientDetails(userName, password);
        if (clientDetails == null || clientDetails.getStockHoldings() == null) {
            return null;
        }
        return clientDetails.getStockHoldings();
    }

    public String getMyEPR() {
        return this.myEPR;
    }

    public void setMyEPR(String myEPR) {
        this.myEPR = myEPR;
    }

    public String getExchangeDefaultEPR() {
        return this.exchangeEPR;
    }
}

