/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.sample.trader.client;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.Map;
import org.apache.axis2.AxisFault;
import org.apache.axis2.context.ServiceContext;
import org.wso2.wsas.sample.trader.Trader;
import org.wso2.wsas.sample.trader.client.TraderClientSkeletonInterface;
import org.wso2.www.types.trader.client.service.ArrayOfString;
import org.wso2.www.types.trader.client.service.BuyRequest;
import org.wso2.www.types.trader.client.service.BuyResponse;
import org.wso2.www.types.trader.client.service.CreateAccountRequest;
import org.wso2.www.types.trader.client.service.CreateAccountResponse;
import org.wso2.www.types.trader.client.service.DepositRequest;
import org.wso2.www.types.trader.client.service.DepositResponse;
import org.wso2.www.types.trader.client.service.GetPortfolioRequest;
import org.wso2.www.types.trader.client.service.GetPortfolioResponse;
import org.wso2.www.types.trader.client.service.GetQuoteRequest;
import org.wso2.www.types.trader.client.service.GetQuoteResponse;
import org.wso2.www.types.trader.client.service.GetSymbolsRequest;
import org.wso2.www.types.trader.client.service.GetSymbolsResponse;
import org.wso2.www.types.trader.client.service.PortFolio;
import org.wso2.www.types.trader.client.service.PortFolioItem;
import org.wso2.www.types.trader.client.service.SellRequest;
import org.wso2.www.types.trader.client.service.SellResponse;
import org.wso2.www.types.trader.client.service.StockQuote;
import org.wso2.www.types.trader.client.service.TradeStatus;

public class TraderClientSkeleton
implements TraderClientSkeletonInterface {
    private Trader trader;
    public static boolean testing = false;
    public static String testingExchangeServiceName;

    public void init(ServiceContext serviceContext) throws AxisFault {
        try {
            this.trader = !testing ? Trader.getInstance().createTraderWithExchangeEPR(serviceContext.getConfigurationContext().getServiceContextPath()) : Trader.getInstance().createTraderWithExchangeEPR(serviceContext.getConfigurationContext().getServiceContextPath(), testingExchangeServiceName);
        }
        catch (Exception e) {
            throw AxisFault.makeFault((Throwable)e);
        }
    }

    public SellResponse sell(SellRequest request) {
        SellResponse sellResponse = new SellResponse();
        try {
            this.trader.sell(request.getUserid(), request.getPassword(), request.getSymbol(), request.getQty().intValue());
            TradeStatus tradeStatus = this.getTradeStatus(true, "Success");
            sellResponse.setTrade_status(tradeStatus);
        }
        catch (Exception e) {
            sellResponse.setTrade_status(this.getTradeStatus(false, e.getMessage()));
        }
        return sellResponse;
    }

    private TradeStatus getTradeStatus(boolean status, String reason) {
        TradeStatus tradeStatus = new TradeStatus();
        tradeStatus.setReason(reason);
        tradeStatus.setStatus(status);
        return tradeStatus;
    }

    public BuyResponse buy(BuyRequest buyReq) {
        BuyResponse buyResponse = new BuyResponse();
        try {
            this.trader.buy(buyReq.getUserid(), buyReq.getPassword(), buyReq.getSymbol(), buyReq.getQty());
            buyResponse.setTrade_status(this.getTradeStatus(true, "Success"));
        }
        catch (Exception e) {
            buyResponse.setTrade_status(this.getTradeStatus(false, e.getMessage()));
        }
        return buyResponse;
    }

    public GetPortfolioResponse getPortfolio(GetPortfolioRequest portFolioReq) {
        GetPortfolioResponse portfolioResponse = new GetPortfolioResponse();
        PortFolio portFolio = new PortFolio();
        try {
            ArrayList<PortFolioItem> portFoliItems = new ArrayList<PortFolioItem>();
            Map portfolioMap = this.trader.getPortfolio(portFolioReq.getUserid(), portFolioReq.getPassword());
            if (portfolioMap == null) {
                PortFolioItem portFolioItem = this.getPortfolioItem("Invalid", 0);
                portFolio.setPortFolioItem(new PortFolioItem[]{portFolioItem});
            } else {
                Iterator keyIter = portfolioMap.keySet().iterator();
                while (keyIter.hasNext()) {
                    String symbol = (String)keyIter.next();
                    portFoliItems.add(this.getPortfolioItem(symbol, (Integer)portfolioMap.get(symbol)));
                }
                if (portFoliItems.size() == 0) {
                    portFolio.setPortFolioItem(new PortFolioItem[]{this.getPortfolioItem("Empty", 0)});
                } else {
                    portFolio.setPortFolioItem(portFoliItems.toArray(new PortFolioItem[portFoliItems.size()]));
                }
            }
        }
        catch (Exception e) {
            portFolio.setPortFolioItem(new PortFolioItem[]{this.getPortfolioItem("Invalid", 0)});
        }
        portfolioResponse.setPortFolio(portFolio);
        return portfolioResponse;
    }

    private PortFolioItem getPortfolioItem(String symbol, int amount) {
        PortFolioItem portFolioItem = new PortFolioItem();
        portFolioItem.setAmount(amount);
        portFolioItem.setSymbol(symbol);
        return portFolioItem;
    }

    public DepositResponse deposit(DepositRequest depositReq) {
        DepositResponse depositResponse = new DepositResponse();
        try {
            this.trader.depositMoney(depositReq.getUseridr(), depositReq.getPassword(), depositReq.getAmount());
            depositResponse.setDepositStatus("Deposit Successful !!");
        }
        catch (Exception e) {
            depositResponse.setDepositStatus("Deposit failed. Reason : " + e.getMessage());
        }
        return depositResponse;
    }

    public GetQuoteResponse getQuote(GetQuoteRequest param8) {
        GetQuoteResponse getQuoteResponse = new GetQuoteResponse();
        StockQuote quote = this.trader.getQuote(param8.getSymbol());
        if (quote == null) {
            getQuoteResponse.setStock_quote(new StockQuote());
        }
        getQuoteResponse.setStock_quote(quote);
        return getQuoteResponse;
    }

    public CreateAccountResponse createAccount(CreateAccountRequest createAccReq) {
        CreateAccountResponse createAccResp = new CreateAccountResponse();
        String userAccountId = this.trader.createUserAccount(createAccReq.getClientinfo().getSsn(), createAccReq.getClientinfo().getName(), createAccReq.getPassword());
        createAccResp.setUserid(userAccountId);
        return createAccResp;
    }

    public GetSymbolsResponse getSymbols(GetSymbolsRequest param12) {
        GetSymbolsResponse getSymbolsResponse = new GetSymbolsResponse();
        ArrayOfString arrayOfString = new ArrayOfString();
        arrayOfString.setValue(this.trader.getSymbols());
        getSymbolsResponse.set_return(arrayOfString);
        return getSymbolsResponse;
    }
}

