/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.sample.xfer.client;

import org.apache.axiom.om.OMAbstractFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMNode;
import org.apache.axiom.soap.SOAPEnvelope;
import org.apache.axiom.soap.SOAPFactory;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.OperationClient;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.apache.axis2.context.MessageContext;
import org.wso2.wsas.sample.util.CustomerUtil;
import org.wso2.wsas.sample.xfer.Customer;

public class CustomerServiceClient {
    public static void main(String[] args) throws Exception {
        ServiceClient serviceClient = new ServiceClient();
        OperationClient opClient = serviceClient.createClient(ServiceClient.ANON_OUT_IN_OP);
        Options options = opClient.getOptions();
        options.setAction("http://schemas.xmlsoap.org/ws/2004/09/transfer/Create");
        EndpointReference epr = new EndpointReference("http://10.100.1.204:9762/services/CustomerService");
        options.setTo(epr);
        MessageContext msgCtx = new MessageContext();
        opClient.addMessageContext(msgCtx);
        SOAPFactory factory = OMAbstractFactory.getSOAP12Factory();
        SOAPEnvelope env = factory.getDefaultEnvelope();
        Customer customer = new Customer();
        customer.setId("1");
        customer.setFirst("Roy");
        customer.setLast("Hill");
        customer.setAddress("321, Main Street");
        customer.setCity("Manhattan Beach");
        customer.setState("CA");
        customer.setZip("9226");
        env.getBody().addChild((OMNode)CustomerUtil.toOM(customer));
        msgCtx.setEnvelope(env);
        System.out.println("Creating a nex Customer");
        CustomerUtil.printCustomerInfo(customer);
        opClient.execute(true);
        opClient = serviceClient.createClient(ServiceClient.ANON_OUT_IN_OP);
        options = opClient.getOptions();
        options.setTo(epr);
        options.setAction("http://schemas.xmlsoap.org/ws/2004/09/transfer/Get");
        env = factory.getDefaultEnvelope();
        msgCtx = new MessageContext();
        opClient.addMessageContext(msgCtx);
        OMElement customerIdHeader = factory.createOMElement(Customer.Q_ELEM_CUSTOMER_ID.getLocalPart(), Customer.Q_ELEM_CUSTOMER_ID.getNamespaceURI(), "xxx");
        customerIdHeader.setText("1");
        env.getHeader().addChild((OMNode)customerIdHeader);
        msgCtx.setEnvelope(env);
        System.out.println("Retriving the Customer with CustomId - 1");
        opClient.execute(true);
        MessageContext inMsgCtx = opClient.getMessageContext("In");
        OMElement element = inMsgCtx.getEnvelope().getBody().getFirstElement();
        Customer customer2 = CustomerUtil.fromOM(element);
        CustomerUtil.printCustomerInfo(customer2);
    }
}

