/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.sample.xkms.locate;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.xml.security.keys.KeyInfo;
import org.wso2.wsas.sample.xkms.utils.Utils;
import org.wso2.xkms2.LocateRequest;
import org.wso2.xkms2.LocateResult;
import org.wso2.xkms2.QueryKeyBinding;
import org.wso2.xkms2.RespondWith;
import org.wso2.xkms2.ResultMinor;
import org.wso2.xkms2.UnverifiedKeyBinding;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.builder.LocateResultBuilder;

public class LocateServiceDemo {
    private static String XKMS_SERVICE_URL = "http://127.0.0.1:9762/services/xkms";
    private static String WSO2_HOME = System.getProperty("wso2wsas.home");
    private static String separator = File.separator;

    public static void main(String[] args) throws Exception {
        LocateServiceDemo.fetchCert("alice");
        LocateServiceDemo.fetchCert("jane");
    }

    private static void fetchCert(String alias) throws Exception {
        String location = WSO2_HOME + separator + "samples" + separator + "XKMS" + separator + "conf" + separator + "keystore.jks";
        String password = "password";
        FileInputStream fis = new FileInputStream(location);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(fis, password.toCharArray());
        LocateRequest request = Utils.createLocateRequest();
        request.setServiceURI(XKMS_SERVICE_URL);
        QueryKeyBinding keyBinding = Utils.createQueryKeyBinding();
        keyBinding.setKeyName(alias);
        request.setQueryKeyBinding(keyBinding);
        request.addRespondWith(RespondWith.X_509_CERT);
        OMElement element = LocateServiceDemo.getAsOMElement(request);
        OMElement result = Utils.sendReceive(element, XKMS_SERVICE_URL);
        result = Utils.buildElement(result);
        LocateResult locateResult = LocateServiceDemo.getLocateResult(result);
        if (ResultMinor.NO_MATCH.equals(locateResult.getResultMinor())) {
            System.out.println("No X509Certificate is found for the alias : " + alias);
        } else {
            System.out.println(" X509Certificate found for alias : " + alias);
            List keybindings = locateResult.getUnverifiedKeyBindingList();
            UnverifiedKeyBinding keybinding = (UnverifiedKeyBinding)keybindings.get(0);
            KeyInfo keyInfo = keybinding.getKeyInfo();
            X509Certificate cert = keyInfo.getX509Certificate();
            Utils.printCert(cert);
        }
    }

    private static OMElement getAsOMElement(LocateRequest request) throws XKMSException {
        OMFactory factory = DOOMAbstractFactory.getOMFactory();
        return request.serialize(factory);
    }

    private static LocateResult getLocateResult(OMElement result) throws Exception {
        LocateResult locateResult = (LocateResult)LocateResultBuilder.INSTANCE.buildElement(result);
        return locateResult;
    }
}

