/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.sample.xkms.recover;

import java.security.Key;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.KeyInfo;
import org.wso2.wsas.sample.xkms.utils.Utils;
import org.wso2.xkms2.Authentication;
import org.wso2.xkms2.KeyBinding;
import org.wso2.xkms2.PrivateKey;
import org.wso2.xkms2.RecoverKeyBinding;
import org.wso2.xkms2.RecoverRequest;
import org.wso2.xkms2.RecoverResult;
import org.wso2.xkms2.RespondWith;
import org.wso2.xkms2.Status;
import org.wso2.xkms2.StatusValue;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.builder.RecoverResultBuilder;
import org.wso2.xkms2.util.XKMSKeyUtil;

public class RecoverServiceDemo {
    private static String XKMS_SERVICE_URL = "http://127.0.0.1:9762/services/xkms";
    private static String PASS_PHRASE = "secret";

    public static void main(String[] args) throws Exception {
        RecoverRequest request = Utils.createRecoverRequest();
        request.setServiceURI(XKMS_SERVICE_URL);
        Authentication authentication = new Authentication();
        Key authenKey = XKMSKeyUtil.getAuthenticationKey((String)PASS_PHRASE);
        authentication.setKeyBindingAuthenticationKey(authenKey);
        request.setAuthentication(authentication);
        RecoverKeyBinding keyBinding = Utils.createRecoverKeyBinding();
        keyBinding.addUseKeyWith("urn:ietf:rfc:2459", "CN=Bob, OU=OASIS Interop Test Cert, O=OASIS");
        Status status = new Status();
        status.setStatusValue(StatusValue.INDETERMINATE);
        keyBinding.setStatus(status);
        request.setRecoverKeyBinding(keyBinding);
        request.addRespondWith(RespondWith.X_509_CERT);
        request.addRespondWith(RespondWith.PRIVATE_KEY);
        OMElement element = RecoverServiceDemo.getAsOMElement(request);
        OMElement result = Utils.sendReceive(element, XKMS_SERVICE_URL);
        result = Utils.buildElement(result);
        RecoverResult recoverResult = RecoverServiceDemo.getRecoverResult(result);
        List keybindings = recoverResult.getKeyBindings();
        KeyBinding keybinding = (KeyBinding)keybindings.get(0);
        KeyInfo keyInfo = keybinding.getKeyInfo();
        X509Certificate cert = keyInfo.getX509Certificate();
        System.out.println("Recovered X509Certificate");
        Utils.printCert(cert);
        PrivateKey privateKey = recoverResult.getPrivateKey();
        Key decryptionKey = XKMSKeyUtil.getPrivateKey((String)"secret", (String)"DESede");
        privateKey.setKey(decryptionKey);
        KeyPair rsaKeyPair = privateKey.getRSAKeyPair();
        System.out.println("Recovered Private Key");
        Utils.printRSAPrivateKey((RSAPrivateCrtKey)rsaKeyPair.getPrivate());
    }

    private static OMElement getAsOMElement(RecoverRequest request) throws XKMSException {
        OMFactory factory = DOOMAbstractFactory.getOMFactory();
        return request.serialize(factory);
    }

    private static RecoverResult getRecoverResult(OMElement recoverResultElem) throws Exception {
        return (RecoverResult)RecoverResultBuilder.INSTANCE.buildElement(recoverResultElem);
    }

    static {
        Init.init();
    }
}

