/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.sample.xkms.register;

import java.security.Key;
import java.security.KeyPair;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.xml.security.Init;
import org.apache.xml.security.keys.KeyInfo;
import org.apache.xml.security.keys.content.KeyName;
import org.wso2.wsas.sample.xkms.utils.Utils;
import org.wso2.xkms2.Authentication;
import org.wso2.xkms2.KeyBinding;
import org.wso2.xkms2.KeyUsage;
import org.wso2.xkms2.PrivateKey;
import org.wso2.xkms2.PrototypeKeyBinding;
import org.wso2.xkms2.RegisterRequest;
import org.wso2.xkms2.RegisterResult;
import org.wso2.xkms2.RespondWith;
import org.wso2.xkms2.builder.RegisterResultBuilder;
import org.wso2.xkms2.util.XKMSKeyUtil;

public class RegisterServiceDemo2 {
    private static String XKMS_SERVICE_URL = "http://127.0.0.1:9762/services/xkms";
    private static String PASS_PHRASE = "secret";

    public static void main(String[] args) throws Exception {
        X509Certificate cert;
        RegisterRequest request = Utils.createRegisterRequest();
        request.setServiceURI(XKMS_SERVICE_URL);
        Authentication authentication = Utils.createAuthenticate();
        Key authKey = XKMSKeyUtil.getAuthenticationKey((String)PASS_PHRASE);
        authentication.setKeyBindingAuthenticationKey(authKey);
        request.setAuthentication(authentication);
        PrototypeKeyBinding keyBinding = Utils.createPrototypeKeyBinding();
        keyBinding.addKeyUsage(KeyUsage.SIGNATURE);
        keyBinding.addUseKeyWith("urn:ietf:rfc:2459", "C=US, ST=NY, L=NYC, O=Yahoo, OU=XKMS, CN=Motukuru");
        request.setPrototypeKeyBinding(keyBinding);
        request.addRespondWith(RespondWith.KEY_NAME);
        request.addRespondWith(RespondWith.X_509_CERT);
        OMElement element = RegisterServiceDemo2.getAsOMElement(request);
        OMElement result = Utils.sendReceive(element, XKMS_SERVICE_URL);
        result = Utils.buildElement(result);
        RegisterResult registerResult = RegisterServiceDemo2.getRegisterResult(result);
        List keybindings = registerResult.getKeyBindings();
        KeyBinding keybinding = (KeyBinding)keybindings.get(0);
        KeyInfo keyInfo = keybinding.getKeyInfo();
        KeyName keyName = keyInfo.itemKeyName(0);
        if (keyName != null) {
            System.out.println("KeyName : " + keyName.getKeyName());
        }
        if ((cert = keyInfo.getX509Certificate()) != null) {
            System.out.println("X509Certificate : ");
            Utils.printCert(cert);
        }
        PrivateKey privateKey = registerResult.getPrivateKey();
        Key decryptionKey = XKMSKeyUtil.getPrivateKey((String)"secret", (String)"DESede");
        privateKey.setKey(decryptionKey);
        KeyPair rsaKeyPair = privateKey.getRSAKeyPair();
        RSAPrivateCrtKey private1 = (RSAPrivateCrtKey)rsaKeyPair.getPrivate();
        Utils.printRSAPrivateKey(private1);
    }

    private static OMElement getAsOMElement(RegisterRequest registerRequest) throws Exception {
        return registerRequest.serialize(DOOMAbstractFactory.getOMFactory());
    }

    private static RegisterResult getRegisterResult(OMElement registerResult) throws Exception {
        return (RegisterResult)RegisterResultBuilder.INSTANCE.buildElement(registerResult);
    }

    static {
        Init.init();
    }
}

