/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.sample.xkms.utils;

import java.io.ByteArrayInputStream;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.security.interfaces.RSAPrivateCrtKey;
import javax.security.auth.x500.X500Principal;
import javax.xml.stream.XMLInputFactory;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.impl.builder.StAXOMBuilder;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.axis2.AxisFault;
import org.apache.axis2.addressing.EndpointReference;
import org.apache.axis2.client.Options;
import org.apache.axis2.client.ServiceClient;
import org.wso2.xkms2.Authentication;
import org.wso2.xkms2.LocateRequest;
import org.wso2.xkms2.PrototypeKeyBinding;
import org.wso2.xkms2.QueryKeyBinding;
import org.wso2.xkms2.RecoverKeyBinding;
import org.wso2.xkms2.RecoverRequest;
import org.wso2.xkms2.RegisterRequest;
import org.wso2.xkms2.ReissueKeyBinding;
import org.wso2.xkms2.ReissueRequest;
import org.wso2.xkms2.ValidateRequest;
import org.wso2.xkms2.util.XKMSUtil;

public class Utils {
    public static RegisterRequest createRegisterRequest() {
        RegisterRequest request = new RegisterRequest();
        request.setId(XKMSUtil.getRamdomId());
        return request;
    }

    public static Authentication createAuthenticate() {
        Authentication authentication = new Authentication();
        return authentication;
    }

    public static PrototypeKeyBinding createPrototypeKeyBinding() {
        PrototypeKeyBinding keyBinding = new PrototypeKeyBinding();
        keyBinding.setId(XKMSUtil.getRamdomId());
        return keyBinding;
    }

    public static QueryKeyBinding createQueryKeyBinding() {
        QueryKeyBinding binding = new QueryKeyBinding();
        binding.setId(XKMSUtil.getRamdomId());
        return binding;
    }

    public static ReissueRequest createReissueRequest() {
        ReissueRequest reissueRequest = new ReissueRequest();
        reissueRequest.setId(XKMSUtil.getRamdomId());
        return reissueRequest;
    }

    public static ReissueKeyBinding createReissueKeyBinding() {
        ReissueKeyBinding reissueKeyBinding = new ReissueKeyBinding();
        reissueKeyBinding.setId(XKMSUtil.getRamdomId());
        return reissueKeyBinding;
    }

    public static RecoverKeyBinding createRecoverKeyBinding() {
        RecoverKeyBinding recoverKeyBinding = new RecoverKeyBinding();
        recoverKeyBinding.setId(XKMSUtil.getRamdomId());
        return recoverKeyBinding;
    }

    public static RecoverRequest createRecoverRequest() {
        RecoverRequest recoverRequest = new RecoverRequest();
        recoverRequest.setId(XKMSUtil.getRamdomId());
        return recoverRequest;
    }

    public static ValidateRequest createValidateRequest() {
        ValidateRequest validate = new ValidateRequest();
        validate.setId(XKMSUtil.getRamdomId());
        return validate;
    }

    public static LocateRequest createLocateRequest() {
        LocateRequest locate = new LocateRequest();
        locate.setId(XKMSUtil.getRamdomId());
        return locate;
    }

    public static OMElement sendReceive(OMElement element, String serviceURL) throws AxisFault {
        ServiceClient client = new ServiceClient();
        Options options = client.getOptions();
        EndpointReference epr = new EndpointReference(serviceURL);
        options.setTo(epr);
        options.setProperty("__CHUNKED__", (Object)Boolean.FALSE);
        options.setSoapVersionURI("http://www.w3.org/2003/05/soap-envelope");
        OMElement result = client.sendReceive(element);
        return result;
    }

    public static OMElement buildElement(OMElement element) throws Exception {
        String str = element.toString();
        ByteArrayInputStream bais = new ByteArrayInputStream(str.getBytes());
        StAXOMBuilder builder = new StAXOMBuilder(DOOMAbstractFactory.getOMFactory(), XMLInputFactory.newInstance().createXMLStreamReader(bais));
        return builder.getDocumentElement();
    }

    public static KeyPair generateRSAKeyPair() {
        try {
            KeyPairGenerator keyGen = KeyPairGenerator.getInstance("RSA");
            keyGen.initialize(1024);
            return keyGen.genKeyPair();
        }
        catch (NoSuchAlgorithmException e) {
            throw new RuntimeException(e);
        }
    }

    public static void printCert(X509Certificate cert) {
        System.out.println("--------------- Cert Info ----------------------------");
        X500Principal subjectX500Principal = cert.getSubjectX500Principal();
        System.out.println("SubjectDN : " + subjectX500Principal.getName());
        System.out.println("Not After : " + cert.getNotAfter());
        System.out.println("Not Before : " + cert.getNotBefore());
        System.out.println("Public Key :\n" + cert.getPublicKey());
        X500Principal issuerX500Principal = cert.getIssuerX500Principal();
        System.out.println("IssuerDN : " + issuerX500Principal.getName());
        System.out.println("IssuerSerial : " + cert.getSerialNumber());
        System.out.println("--------------- End Cert Info -------------------------");
    }

    public static void printRSAPrivateKey(RSAPrivateCrtKey private1) {
        System.out.println("----------------  Private Key Info ------------------");
        System.out.println(private1);
        System.out.println("----------------  End Private Key Info --------------");
    }
}

