/*
 * Decompiled with CFR 0.152.
 */
package org.wso2.wsas.sample.xkms.validate;

import java.io.File;
import java.io.FileInputStream;
import java.security.KeyStore;
import java.security.cert.X509Certificate;
import java.util.List;
import org.apache.axiom.om.OMElement;
import org.apache.axiom.om.OMFactory;
import org.apache.axiom.om.impl.dom.DOOMAbstractFactory;
import org.apache.xml.security.keys.KeyInfo;
import org.wso2.wsas.sample.xkms.utils.Utils;
import org.wso2.xkms2.KeyBinding;
import org.wso2.xkms2.QueryKeyBinding;
import org.wso2.xkms2.RespondWith;
import org.wso2.xkms2.Status;
import org.wso2.xkms2.StatusValue;
import org.wso2.xkms2.ValidateRequest;
import org.wso2.xkms2.ValidateResult;
import org.wso2.xkms2.XKMSException;
import org.wso2.xkms2.builder.ValidateResultBuilder;

public class ValidateServiceDemo {
    private static String XKMS_SERVICE_URL = "http://127.0.0.1:9762/services/xkms";
    private static String WSO2_HOME = System.getProperty("wso2wsas.home");
    private static String separator = File.separator;

    public static void main(String[] args) throws Exception {
        ValidateServiceDemo.verifyCert("alice");
        ValidateServiceDemo.verifyCert("root");
    }

    private static void verifyCert(String alias) throws Exception {
        String location = WSO2_HOME + separator + "samples" + separator + "XKMS" + separator + "conf" + separator + "keystore.jks";
        String password = "password";
        FileInputStream fis = new FileInputStream(location);
        KeyStore keyStore = KeyStore.getInstance(KeyStore.getDefaultType());
        keyStore.load(fis, password.toCharArray());
        X509Certificate cert = (X509Certificate)keyStore.getCertificate("root");
        ValidateRequest request = Utils.createValidateRequest();
        request.setServiceURI(XKMS_SERVICE_URL);
        QueryKeyBinding keyBinding = Utils.createQueryKeyBinding();
        keyBinding.setCertValue(cert);
        String name = cert.getSubjectDN().getName();
        keyBinding.addUseKeyWith("urn:ietf:rfc:2459", name);
        request.setQueryKeyBinding(keyBinding);
        request.addRespondWith(RespondWith.X_509_CERT);
        OMElement element = ValidateServiceDemo.getElement(request);
        OMElement result = Utils.sendReceive(element, XKMS_SERVICE_URL);
        result = Utils.buildElement(result);
        ValidateResult validateResult = ValidateServiceDemo.getValidateResult(result);
        List keybinds = validateResult.getKeyBindingList();
        KeyBinding keybinding = (KeyBinding)keybinds.get(0);
        KeyInfo keyInfo = keybinding.getKeyInfo();
        X509Certificate cert2 = keyInfo.getX509Certificate();
        Status status = keybinding.getStatus();
        if (StatusValue.VALID.equals(status.getStatusValue())) {
            System.out.println("certificate '" + alias + "' is a trusted one");
            Utils.printCert(cert2);
        } else {
            System.out.println("certificate '" + alias + "' is not a trusted one");
            Utils.printCert(cert);
        }
    }

    private static OMElement getElement(ValidateRequest request) throws XKMSException {
        OMFactory factory = DOOMAbstractFactory.getOMFactory();
        return request.serialize(factory);
    }

    private static ValidateResult getValidateResult(OMElement element) throws XKMSException {
        return (ValidateResult)ValidateResultBuilder.INSTANCE.buildElement(element);
    }
}

