/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.internal;

import java.io.Reader;
import java.io.Writer;
import java.util.HashSet;
import java.util.Properties;
import java.util.Set;
import javax.inject.Inject;
import javax.inject.Provider;
import javax.inject.Singleton;
import javax.script.ScriptContext;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.RuntimeServices;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.manager.ComponentManager;
import org.xwiki.component.phase.Initializable;
import org.xwiki.component.phase.InitializationException;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.logging.LoggerConfiguration;
import org.xwiki.script.ScriptContextManager;
import org.xwiki.velocity.ScriptVelocityContext;
import org.xwiki.velocity.VelocityConfiguration;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityManager;
import org.xwiki.velocity.VelocityTemplate;
import org.xwiki.velocity.XWikiVelocityException;
import org.xwiki.velocity.internal.InternalVelocityEngine;
import org.xwiki.velocity.internal.directive.TryCatchDirective;

@Component
@Singleton
public class DefaultVelocityManager
implements VelocityManager,
Initializable {
    @Inject
    protected Execution execution;
    @Inject
    private ScriptContextManager scriptContextManager;
    @Inject
    private LoggerConfiguration loggerConfiguration;
    @Inject
    private VelocityConfiguration velocityConfiguration;
    @Inject
    private ComponentManager componentManager;
    @Inject
    private Provider<InternalVelocityEngine> engineProvider;
    private final Set<String> reservedBindings = new HashSet<String>();
    private RuntimeInstance runtimeInstance;
    private VelocityEngine mainVelocityEngine;

    public void initialize() throws InitializationException {
        this.reservedBindings.add("context");
        this.reservedBindings.add("macro");
        this.reservedBindings.add("foreach");
        this.reservedBindings.add("evaluate");
        this.reservedBindings.add("exception");
        this.reservedBindings.add("try");
        this.reservedBindings.add("define");
        this.reservedBindings.add("template");
    }

    private RuntimeInstance getRuntimeInstance() throws XWikiVelocityException {
        if (this.runtimeInstance == null) {
            this.runtimeInstance = this.initializeRuntimeInstance(this.componentManager, this.velocityConfiguration);
        }
        return this.runtimeInstance;
    }

    private synchronized RuntimeInstance initializeRuntimeInstance(ComponentManager componentManager, VelocityConfiguration velocityConfiguration) throws XWikiVelocityException {
        RuntimeInstance runtime = new RuntimeInstance();
        runtime.setApplicationAttribute((Object)ComponentManager.class.getName(), (Object)componentManager);
        this.initializeProperties(runtime, velocityConfiguration.getProperties());
        runtime.loadDirective(TryCatchDirective.class.getName());
        try {
            runtime.init();
        }
        catch (Exception e) {
            throw new XWikiVelocityException("Cannot start the Velocity engine", e);
        }
        return runtime;
    }

    private void initializeProperties(RuntimeInstance runtime, Properties configurationProperties) {
        runtime.setProperty("velocimacro.library.path", (Object)"");
        if (configurationProperties != null) {
            runtime.setProperties(configurationProperties);
        }
    }

    public static VelocityTemplate compile(String name, Reader source, RuntimeInstance runtimeInstance) {
        VelocityTemplate template = new VelocityTemplate(name, (RuntimeServices)runtimeInstance);
        template.compile(source);
        return template;
    }

    @Override
    public VelocityTemplate compile(String name, Reader source) throws XWikiVelocityException {
        return DefaultVelocityManager.compile(name, source, this.getRuntimeInstance());
    }

    @Override
    public VelocityContext getVelocityContext() {
        return this.getScriptVelocityContext();
    }

    protected ScriptVelocityContext getScriptVelocityContext() {
        ScriptVelocityContext velocityContext;
        VelocityContext currentVelocityContext = this.getCurrentVelocityContext();
        if (currentVelocityContext instanceof ScriptVelocityContext) {
            velocityContext = (ScriptVelocityContext)currentVelocityContext;
        } else {
            velocityContext = new ScriptVelocityContext(currentVelocityContext, this.loggerConfiguration.isDeprecatedLogEnabled(), this.reservedBindings);
            ExecutionContext eContext = this.execution.getContext();
            if (eContext != null) {
                eContext.setProperty("velocityContext", (Object)velocityContext);
            }
        }
        ScriptContext scriptContext = this.scriptContextManager.getScriptContext();
        velocityContext.setScriptContext(scriptContext);
        return velocityContext;
    }

    @Override
    public VelocityContext getCurrentVelocityContext() {
        ExecutionContext eContext = this.execution.getContext();
        return eContext != null ? (VelocityContext)eContext.getProperty("velocityContext") : null;
    }

    @Override
    public VelocityEngine getVelocityEngine() throws XWikiVelocityException {
        if (this.mainVelocityEngine == null) {
            this.mainVelocityEngine = this.createVelocityEngine();
        }
        return this.mainVelocityEngine;
    }

    protected synchronized VelocityEngine createVelocityEngine() throws XWikiVelocityException {
        InternalVelocityEngine velocityEngine = (InternalVelocityEngine)this.engineProvider.get();
        velocityEngine.initialize(this.getRuntimeInstance());
        return velocityEngine;
    }

    @Override
    public boolean evaluate(Writer out, String templateName, Reader source) throws XWikiVelocityException {
        VelocityContext velocityContext = this.getVelocityContext();
        return this.getVelocityEngine().evaluate((Context)velocityContext, out, templateName, source);
    }
}

