/*
 * Decompiled with CFR 0.152.
 */
package org.xwiki.velocity.internal;

import java.io.Reader;
import java.io.StringReader;
import java.io.Writer;
import java.util.Deque;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.inject.Inject;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.exception.ExceptionUtils;
import org.apache.commons.lang3.reflect.FieldUtils;
import org.apache.velocity.Template;
import org.apache.velocity.VelocityContext;
import org.apache.velocity.context.Context;
import org.apache.velocity.runtime.RuntimeInstance;
import org.apache.velocity.runtime.RuntimeServices;
import org.apache.velocity.runtime.resource.Resource;
import org.slf4j.Logger;
import org.xwiki.component.annotation.Component;
import org.xwiki.component.annotation.InstantiationStrategy;
import org.xwiki.component.descriptor.ComponentInstantiationStrategy;
import org.xwiki.context.Execution;
import org.xwiki.context.ExecutionContext;
import org.xwiki.velocity.VelocityContextFactory;
import org.xwiki.velocity.VelocityEngine;
import org.xwiki.velocity.VelocityTemplate;
import org.xwiki.velocity.XWikiVelocityException;
import org.xwiki.velocity.internal.DefaultVelocityManager;

@Component(roles={InternalVelocityEngine.class})
@InstantiationStrategy(value=ComponentInstantiationStrategy.PER_LOOKUP)
public class InternalVelocityEngine
implements VelocityEngine {
    private static final String ECONTEXT_TEMPLATES = "velocity.templates";
    @Inject
    private VelocityContextFactory velocityContextFactory;
    @Inject
    private Execution execution;
    @Inject
    private Logger logger;
    private RuntimeInstance runtimeInstance;
    private TemplateEntry globalEntry;

    public void initialize(RuntimeInstance runtimeInstance) {
        this.runtimeInstance = runtimeInstance;
        this.globalEntry = new TemplateEntry("");
    }

    @Override
    public void addGlobalMacros(Map<String, Object> macros) {
        this.globalEntry.getTemplate().getMacros().putAll(macros);
    }

    @Override
    public boolean evaluate(Context context, Writer out, String namespace, String source) throws XWikiVelocityException {
        return this.evaluate(context, out, namespace, new StringReader(source));
    }

    @Override
    public boolean evaluate(Context context, Writer out, String namespace, Reader source) throws XWikiVelocityException {
        VelocityTemplate template = DefaultVelocityManager.compile(namespace != null ? namespace : "unknown template", source, this.runtimeInstance);
        this.evaluate(context, out, namespace, template);
        return true;
    }

    private TemplateEntry pushNamespace(String namespace) {
        TemplateEntry templateEntry = StringUtils.isNotEmpty((CharSequence)namespace) ? this.startedUsingMacroNamespaceInternal(namespace) : this.globalEntry;
        return templateEntry;
    }

    private void popNamespace(String namespace) {
        if (StringUtils.isNotEmpty((CharSequence)namespace)) {
            this.stoppedUsingMacroNamespace(namespace);
        }
    }

    @Override
    public void evaluate(Context context, Writer out, String namespace, VelocityTemplate template) throws XWikiVelocityException {
        Resource currentResource = null;
        List currentMacroLibraries = null;
        if (context instanceof VelocityContext) {
            currentResource = ((VelocityContext)context).getCurrentResource();
            currentMacroLibraries = ((VelocityContext)context).getMacroLibraries();
        }
        try {
            Context mergeContext;
            TemplateEntry templateEntry = this.pushNamespace(namespace);
            templateEntry.getTemplate().getMacros().putAll(template.getMacros());
            Object object = mergeContext = context != null ? context : this.velocityContextFactory.createContext();
            if (context instanceof VelocityContext) {
                ((VelocityContext)context).setMacroLibraries(List.of(templateEntry.getTemplate()));
            }
            template.getTemplate().merge(mergeContext, out);
        }
        catch (Exception e) {
            throw new XWikiVelocityException(String.format("Failed to evaluate content with namespace [%s]", namespace), e);
        }
        finally {
            this.popNamespace(namespace);
            if (context instanceof VelocityContext) {
                ((VelocityContext)context).setCurrentResource(currentResource);
                ((VelocityContext)context).setMacroLibraries(currentMacroLibraries);
            }
            this.cleanIntrospectionCache(context);
        }
    }

    private void cleanIntrospectionCache(Context context) {
        if (context != null) {
            try {
                Map introspectionCache = (Map)FieldUtils.readField((Object)context, (String)"introspectionCache", (boolean)true);
                introspectionCache.clear();
            }
            catch (IllegalAccessException e) {
                this.logger.warn("Failed to clean the Velocity context introspection cache. Root error: [{}]", (Object)ExceptionUtils.getRootCauseMessage((Throwable)e));
            }
        }
    }

    @Override
    public void startedUsingMacroNamespace(String namespace) {
        this.startedUsingMacroNamespaceInternal(namespace);
    }

    private Deque<TemplateEntry> getCurrentTemplates(boolean create) {
        ExecutionContext executionContext = this.execution.getContext();
        if (executionContext == null) {
            return null;
        }
        LinkedList templates = (LinkedList)executionContext.getProperty(ECONTEXT_TEMPLATES);
        if (templates == null && create) {
            templates = new LinkedList();
            if (!executionContext.hasProperty(ECONTEXT_TEMPLATES)) {
                executionContext.newProperty(ECONTEXT_TEMPLATES).inherited().declare();
            }
            executionContext.setProperty(ECONTEXT_TEMPLATES, templates);
        }
        return templates;
    }

    private TemplateEntry startedUsingMacroNamespaceInternal(String namespace) {
        TemplateEntry templateEntry;
        Deque<TemplateEntry> templates = this.getCurrentTemplates(true);
        if (templates != null) {
            if (!templates.isEmpty() && templates.peek().getNamespace().equals(namespace)) {
                templateEntry = templates.peek();
                templateEntry.incrementCounter();
            } else {
                templateEntry = new TemplateEntry(namespace);
                templates.push(templateEntry);
            }
        } else {
            templateEntry = new TemplateEntry(namespace);
        }
        return templateEntry;
    }

    @Override
    public void stoppedUsingMacroNamespace(String namespace) {
        Deque<TemplateEntry> templates = this.getCurrentTemplates(true);
        if (templates != null) {
            if (templates.isEmpty()) {
                this.logger.warn("Impossible to pop namespace [{}] because there is no namespace in the stack", (Object)namespace);
            } else {
                this.popTemplateEntry(templates, namespace);
            }
        }
    }

    private void popTemplateEntry(Deque<TemplateEntry> templates, String namespace) {
        TemplateEntry templateEntry = templates.peek();
        if (templateEntry.getNamespace().equals(namespace)) {
            if (templateEntry.getCounter() > 1) {
                templateEntry.decrementCounter();
            } else {
                templates.pop();
            }
        } else {
            this.logger.warn("Impossible to pop namespace [{}] because current namespace is [{}]", (Object)namespace, (Object)templateEntry.getNamespace());
        }
    }

    private class TemplateEntry {
        private Template template;
        private String namespace;
        private int counter;

        TemplateEntry(String namespace) {
            this.namespace = namespace;
            this.template = new Template();
            this.template.setName(namespace);
            this.template.setRuntimeServices((RuntimeServices)InternalVelocityEngine.this.runtimeInstance);
            this.counter = 1;
            if (InternalVelocityEngine.this.globalEntry != null) {
                this.template.getMacros().putAll(InternalVelocityEngine.this.globalEntry.getTemplate().getMacros());
            }
        }

        Template getTemplate() {
            return this.template;
        }

        String getNamespace() {
            return this.namespace;
        }

        int getCounter() {
            return this.counter;
        }

        int incrementCounter() {
            ++this.counter;
            return this.counter;
        }

        int decrementCounter() {
            --this.counter;
            return this.counter;
        }
    }
}

