/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.fn;

import jakarta.servlet.ServletException;
import jakarta.servlet.ServletRequest;
import jakarta.servlet.http.HttpServletRequest;
import java.nio.charset.StandardCharsets;
import java.util.Base64;
import java.util.Comparator;
import java.util.HashMap;
import java.util.Locale;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.zkoss.lang.Library;
import org.zkoss.lang.Strings;
import org.zkoss.util.resource.Locators;
import org.zkoss.web.fn.Color;
import org.zkoss.web.fn.Colors;
import org.zkoss.web.fn.ServletFns;
import org.zkoss.web.fn.ThemeProperties;
import org.zkoss.web.servlet.Servlets;
import org.zkoss.web.theme.StandardTheme;
import org.zkoss.web.theme.Theme;
import org.zkoss.web.theme.ThemeRegistry;
import org.zkoss.web.theme.ThemeResolver;

public class ThemeFns {
    private static String CSS_TEMPLATE = "\t %1$s%2$s:\t %3$s;\n\t %2$s:\t%3$s;";
    private static String CSS_TEMPLATE_W3C = "\t %1$s:\t%2$s;";
    private static ThemeRegistry _themeRegistry = null;
    private static ThemeResolver _themeResolver = null;
    private static final String THEME_PREFERRED_KEY = "org.zkoss.theme.preferred";

    private ThemeFns() {
    }

    private static Browser getBrowser() {
        Double number = Servlets.getBrowser(ServletFns.getCurrentRequest(), "ff");
        if (number != null && number >= 3.6) {
            return Browser.Firefox;
        }
        number = Servlets.getBrowser(ServletFns.getCurrentRequest(), "ie");
        if (number != null) {
            if (number <= 9.0) {
                return Browser.IE9;
            }
            return Browser.IE;
        }
        number = Servlets.getBrowser(ServletFns.getCurrentRequest(), "webkit");
        if (number != null) {
            Double android = Servlets.getBrowser(ServletFns.getCurrentRequest(), "android");
            if (android != null && android < 3.0) {
                return Browser.Old_WebKit;
            }
            Double version = Servlets.getBrowser(ServletFns.getCurrentRequest(), "chrome");
            if (version != null) {
                if (version >= 10.0) {
                    return Browser.WebKit;
                }
                if (version >= 1.0) {
                    return Browser.Old_WebKit;
                }
            }
            if ((version = Servlets.getBrowser(ServletFns.getCurrentRequest(), "ios")) != null && version >= 500.0) {
                return Browser.WebKit;
            }
            version = Servlets.getBrowser(ServletFns.getCurrentRequest(), "safari");
            if (version != null) {
                if (version >= 5.1) {
                    return Browser.WebKit;
                }
                if (version >= 4.0) {
                    return Browser.Old_WebKit;
                }
            }
        }
        if ((number = Servlets.getBrowser(ServletFns.getCurrentRequest(), "opera")) != null && number >= 11.1) {
            return Browser.Opera;
        }
        return Browser.Old;
    }

    public static String gradient(String direction, String colors) {
        Browser temp = ThemeFns.getBrowser();
        if (temp == Browser.Old || temp == Browser.W3C) {
            return "\tbackground:" + ThemeFns.grad(direction, ThemeFns.getBrowser(), colors.split(";"));
        }
        String[] cols = colors.split(";");
        StringBuilder sb = new StringBuilder();
        sb.append("\tbackground:");
        sb.append(ThemeFns.grad(direction, temp, cols));
        sb.append("\tbackground:").append(ThemeFns.grad(direction, Browser.W3C, cols));
        return sb.toString();
    }

    public static String gradValue(String direction, String colors) {
        return ThemeFns.grad(direction, ThemeFns.getBrowser(), colors.split(";")).replace(";", "");
    }

    private static String grad(String dir, Browser template, String[] colors) {
        if ("|ver|hor|diag-|diag+|rad|".indexOf("|" + dir + "|") == -1) {
            throw new IllegalArgumentException("Type must be ver, hor, diag-, diag+, or rad.");
        }
        if (colors.length < 2) {
            throw new IllegalArgumentException("Please specify more than two colors.");
        }
        String color1 = ThemeFns.toHex(colors[0]);
        String color2 = ThemeFns.toHex(colors[1]);
        StringBuilder colorAll = new StringBuilder();
        if (template == Browser.Old_WebKit) {
            for (String color : colors) {
                int end;
                boolean hex = (color = color.trim()).startsWith("#");
                int n = end = hex ? color.indexOf(" ") + 1 : color.indexOf(")") + 1;
                if (end == 0 && !color.toLowerCase(Locale.ENGLISH).contains("transparent")) {
                    if (hex) {
                        throw new IllegalArgumentException("The format of hexadecimal is wrong! [" + color + "] or without stops (%)");
                    }
                    throw new IllegalArgumentException("The format of RGBA is wrong! [" + color + "] or without stops (%)");
                }
                String pos = color.substring(end, color.length());
                color = color.substring(0, end);
                colorAll.append("color-stop(").append(pos).append(',').append(color).append("),");
            }
            int len = colorAll.length();
            if (len > 0) {
                colorAll.delete(len - 1, len);
            }
        } else if (template == Browser.IE9) {
            for (String color : colors) {
                int end;
                boolean hex = (color = color.trim()).startsWith("#");
                int n = end = hex ? color.indexOf(" ") + 1 : color.indexOf(")") + 1;
                if (end == 0 && !color.toLowerCase(Locale.ENGLISH).contains("transparent")) {
                    if (hex) {
                        throw new IllegalArgumentException("The format of hexadecimal is wrong! [" + color + "] or without stops (%)");
                    }
                    throw new IllegalArgumentException("The format of RGBA is wrong! [" + color + "] or without stops (%)");
                }
                String pos = color.substring(end, color.length());
                color = color.substring(0, end);
                colorAll.append("<stop stop-color=\"").append(color).append("\" offset=\"").append(pos).append("\"/>");
            }
        } else {
            for (String color : colors) {
                colorAll.append(color).append(',');
            }
            int len = colorAll.length();
            if (len > 0) {
                colorAll.delete(len - 1, len);
            }
        }
        String gradType = "rad".equals(dir) ? "radial" : "linear";
        int ieGradType = "hor".equals(dir) ? 1 : 0;
        String result = String.format(template.getGradient(dir), color1, color2, "", gradType, ieGradType, colorAll.toString());
        if (template == Browser.IE9) {
            result = "url(data:image/svg+xml;base64," + Base64.getEncoder().encodeToString(result.getBytes(StandardCharsets.UTF_8)) + ");";
        }
        return result;
    }

    public static String gradients(String direction, String colors) {
        StringBuilder sb = new StringBuilder();
        String[] cols = colors.split(";");
        for (Browser grad : Browser.values()) {
            sb.append("\tbackground:");
            sb.append(ThemeFns.grad(direction, grad, cols));
        }
        return sb.toString();
    }

    private static String applyCSS(String styleName, String styleValue) {
        Browser browser = ThemeFns.getBrowser();
        if (!Strings.isEmpty((String)browser.getPrefix())) {
            return String.format(CSS_TEMPLATE, browser.getPrefix(), styleName, styleValue);
        }
        return String.format(CSS_TEMPLATE_W3C, styleName, styleValue);
    }

    public static String applyCSS3(String styleName, String styleValue) {
        return ThemeFns.applyCSS(styleName, styleValue);
    }

    public static String box(String styleName, String styleValue) {
        Browser browser = ThemeFns.getBrowser();
        StringBuilder sb = new StringBuilder(32);
        if (browser == Browser.Firefox || browser == Browser.WebKit) {
            sb.append("\t display:\t").append(browser.getPrefix()).append("box;\n");
        }
        sb.append("\t display:\t box;\n");
        return sb.append(ThemeFns.applyCSS(styleName, styleValue)).toString();
    }

    public static String box2(String styleName, String styleValue, String styleName2, String styleValue2) {
        Browser browser = ThemeFns.getBrowser();
        StringBuilder sb = new StringBuilder(32);
        if (browser == Browser.Firefox || browser == Browser.WebKit) {
            sb.append("\t display:\t").append(browser.getPrefix()).append("box;\n");
        }
        sb.append("\t display:\t box;\n");
        return sb.append(ThemeFns.applyCSS(styleName, styleValue)).append(ThemeFns.applyCSS(styleName2, styleValue2)).toString();
    }

    public static String box3(String styleName, String styleValue, String styleName2, String styleValue2, String styleName3, String styleValue3) {
        Browser browser = ThemeFns.getBrowser();
        StringBuilder sb = new StringBuilder(32);
        if (browser == Browser.Firefox || browser == Browser.WebKit) {
            sb.append("\t display:\t").append(browser.getPrefix()).append("box;\n");
        }
        sb.append("\t display:\t box;\n");
        return sb.append(ThemeFns.applyCSS(styleName, styleValue)).append(ThemeFns.applyCSS(styleName2, styleValue2)).append(ThemeFns.applyCSS(styleName3, styleValue3)).toString();
    }

    public static String transform(String style) {
        return ThemeFns.applyCSS("transform", style);
    }

    public static String boxShadow(String style) {
        return ThemeFns.applyCSS("box-shadow", style);
    }

    public static String borderRadius(String style) {
        return ThemeFns.applyCSS("border-radius", style);
    }

    private static String toHex(String color) {
        HashMap<String, String> colors;
        if ((color = color.trim()).startsWith("#")) {
            int end = color.indexOf(" ");
            if (end > 0) {
                return color.substring(0, end);
            }
            return color;
        }
        int end = color.indexOf(41) + 1;
        if (end > 0) {
            color = color.substring(0, end);
        }
        if ((colors = (HashMap<String, String>)ServletFns.getCurrentRequest().getAttribute("themeFns.colors")) == null) {
            colors = new HashMap<String, String>();
            ServletFns.getCurrentRequest().setAttribute("themeFns.colors", colors);
        }
        if (!colors.containsKey(color)) {
            colors.put(color, ThemeFns.toHex(ThemeFns.toColor(color)));
        }
        return (String)colors.get(color);
    }

    private static String toHex(Color color) {
        return Colors.getHexString(color);
    }

    private static String toIEHex(String color) {
        HashMap<String, String> colors;
        if ((color = color.trim()).startsWith("#")) {
            int end = color.indexOf(" ");
            if (end > 0) {
                return color.substring(0, end);
            }
            return color;
        }
        int end = color.indexOf(41) + 1;
        if (end > 0) {
            color = color.substring(0, end);
        }
        if ((colors = (HashMap<String, String>)ServletFns.getCurrentRequest().getAttribute("themeFns.IEcolors")) == null) {
            colors = new HashMap<String, String>();
            ServletFns.getCurrentRequest().setAttribute("themeFns.IEcolors", colors);
        }
        if (!colors.containsKey(color)) {
            colors.put(color, ThemeFns.toIEHex(ThemeFns.toColor(color)));
        }
        return (String)colors.get(color);
    }

    private static String toIEHex(Color color) {
        return Colors.getIEHexString(color);
    }

    private static String locate(String path) {
        try {
            if (path.startsWith("~./")) {
                path = Servlets.locate(ServletFns.getCurrentServletContext(), ServletFns.getCurrentRequest(), "/web" + path.substring(2), Locators.getDefault());
                return path;
            }
            return Servlets.locate(ServletFns.getCurrentServletContext(), ServletFns.getCurrentRequest(), path, null);
        }
        catch (ServletException ex) {
            ThemeFns.log(ex.getLocalizedMessage());
            return path;
        }
    }

    private static void log(String msg) {
        Logger log = LoggerFactory.getLogger((String)"global");
        if (log.isErrorEnabled()) {
            log.error(msg);
        } else {
            System.err.println(msg);
        }
    }

    public static void loadProperties(String path) {
        if (!ThemeProperties.loadProperties(ServletFns.getCurrentRequest(), ThemeFns.locate(ServletFns.resolveThemeURL(path)))) {
            ThemeFns.log("The properties file is not loaded correctly! [" + path + "]");
        }
    }

    private static Color toColor(String color) {
        return Colors.parseCSS(color);
    }

    public static ThemeRegistry getThemeRegistry() {
        return _themeRegistry;
    }

    public static void setThemeRegistry(ThemeRegistry themeRegistry) {
        _themeRegistry = themeRegistry;
    }

    public static ThemeResolver getThemeResolver() {
        return _themeResolver;
    }

    public static void setThemeResolver(ThemeResolver themeResolver) {
        _themeResolver = themeResolver;
    }

    public static String getCurrentTheme() {
        String t = ThemeFns.getTheme();
        if (_themeRegistry.hasTheme(t)) {
            return t;
        }
        t = Library.getProperty((String)THEME_PREFERRED_KEY);
        if (_themeRegistry.hasTheme(t)) {
            return t;
        }
        Theme[] themes = _themeRegistry.getThemes();
        Theme highest = null;
        Comparator<StandardTheme> comparator = StandardTheme.getComparator();
        for (Theme theme : themes) {
            if (!(theme instanceof StandardTheme) || comparator.compare((StandardTheme)theme, (StandardTheme)highest) >= 0) continue;
            highest = (StandardTheme)theme;
        }
        return highest != null ? highest.getName() : "iceblue";
    }

    private static String getTheme() {
        ServletRequest request = ServletFns.getCurrentRequest();
        if (!(request instanceof HttpServletRequest)) {
            return "iceblue";
        }
        return _themeResolver.getTheme((HttpServletRequest)request);
    }

    private static enum Browser {
        WebKit("-webkit-", "Chrome10+,Safari5.1+"),
        W3C("", "W3C"),
        Firefox("-moz-", "FF3.6+"),
        Opera("-o-", "Opera 11.10+"),
        IE("-ms-", "IE10+"),
        IE9("-ms-", "IE9"),
        Old(null, null),
        Old_WebKit("-webkit-", "Chrome,Safari4+");

        private final String _template;
        private final String _prefix;
        private HashMap<String, String> _GRAD_TYPE = null;

        private Browser(String prefix, String browser) {
            this._prefix = prefix;
            if ("IE9".equals(browser)) {
                this._template = "<svg xmlns=\"http://www.w3.org/2000/svg\" width=\"100%%\" height=\"100%%\" viewBox=\"0 0 1 1\" preserveAspectRatio=\"none\">\n" + "%3$s\n" + "%6$s\n" + "</linearGradient>\n" + "<rect x=\"0\" y=\"0\" width=\"1\" height=\"1\" fill=\"url(#zkie9)\" /></svg>";
                this._GRAD_TYPE = new HashMap();
                this._GRAD_TYPE.put("ver", "<linearGradient id=\"zkie9\" gradientUnits=\"userSpaceOnUse\" x1=\"0%%\" y1=\"0%%\" x2=\"0%%\" y2=\"100%%\">");
                this._GRAD_TYPE.put("hor", "<linearGradient id=\"zkie9\" gradientUnits=\"userSpaceOnUse\" x1=\"0%%\" y1=\"0%%\" x2=\"100%%\" y2=\"0%%\">");
                this._GRAD_TYPE.put("diag-", "<linearGradient id=\"zkie9\" gradientUnits=\"userSpaceOnUse\" x1=\"0%%\" y1=\"0%%\" x2=\"100%%\" y2=\"100%%\">");
                this._GRAD_TYPE.put("diag+", "<linearGradient id=\"zkie9\" gradientUnits=\"userSpaceOnUse\" x1=\"0%%\" y1=\"100%%\" x2=\"100%%\" y2=\"0%%\">");
                this._GRAD_TYPE.put("rad", "<radialGradient id=\"zkie9\" gradientUnits=\"userSpaceOnUse\" cx=\"50%%\" cy=\"50%%\" r=\"50%%\">");
            } else if ("Chrome,Safari4+".equals(browser)) {
                this._template = "\t" + prefix + "gradient(%4$s, %3$s, %6$s); /* " + browser + " */\n";
                this._GRAD_TYPE = new HashMap();
                this._GRAD_TYPE.put("ver", "left top, left bottom");
                this._GRAD_TYPE.put("hor", "left top, right top");
                this._GRAD_TYPE.put("diag-", "left top, right bottom");
                this._GRAD_TYPE.put("diag+", "left bottom, right top");
                this._GRAD_TYPE.put("rad", "center center, 0px, center center, 100%");
            } else if (browser != null) {
                this._template = "\t" + prefix + "%4$s-gradient(%3$s, %6$s); /* " + browser + " */\n";
                if ("W3C".equals(browser)) {
                    this._GRAD_TYPE = new HashMap();
                    this._GRAD_TYPE.put("ver", "to bottom");
                    this._GRAD_TYPE.put("hor", "to right");
                    this._GRAD_TYPE.put("diag-", "135deg");
                    this._GRAD_TYPE.put("diag+", "45deg");
                    this._GRAD_TYPE.put("rad", "ellipse at center");
                } else {
                    this._GRAD_TYPE = new HashMap();
                    this._GRAD_TYPE.put("ver", "top");
                    this._GRAD_TYPE.put("hor", "left");
                    this._GRAD_TYPE.put("diag-", "-45deg");
                    this._GRAD_TYPE.put("diag+", "45deg");
                    this._GRAD_TYPE.put("rad", "center, ellipse cover");
                }
            } else {
                this._template = "\t%1$s; /* Old browsers */\n";
            }
        }

        public String getPrefix() {
            return this._prefix;
        }

        public String getGradient(String dir) {
            return this._template.replace("%3$s", this.getType(dir));
        }

        private String getType(String dir) {
            return this._GRAD_TYPE != null ? this._GRAD_TYPE.get(dir) : "";
        }
    }
}

