/*
 * Decompiled with CFR 0.152.
 */
package org.zkoss.web.servlet;

import jakarta.servlet.ServletOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.io.Writer;
import org.zkoss.io.WriterOutputStream;

public class ServletOutputStreamWrapper
extends ServletOutputStream {
    private final OutputStream _stream;

    public static ServletOutputStream getInstance(OutputStream stream) {
        if (stream instanceof ServletOutputStream) {
            return (ServletOutputStream)stream;
        }
        return new ServletOutputStreamWrapper(stream);
    }

    public static ServletOutputStream getInstance(Writer writer, String charset) {
        return new ServletOutputStreamWrapper(writer, charset);
    }

    private ServletOutputStreamWrapper(OutputStream stream) {
        if (stream == null) {
            throw new IllegalArgumentException("null");
        }
        this._stream = stream;
    }

    public ServletOutputStreamWrapper(Writer writer, String charset) {
        if (writer == null) {
            throw new IllegalArgumentException("null");
        }
        this._stream = new WriterOutputStream(writer, charset);
    }

    public void write(int b) throws IOException {
        this._stream.write(b);
    }

    public void flush() throws IOException {
        this._stream.flush();
        super.flush();
    }

    public void close() throws IOException {
        this._stream.close();
        super.close();
    }
}

