/*
 * Decompiled with CFR 0.152.
 */
package pl.szczepanik.silencio.converters;

import com.fasterxml.jackson.databind.ObjectMapper;
import java.io.IOException;
import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Random;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import pl.szczepanik.silencio.api.Converter;
import pl.szczepanik.silencio.converters.GeoLocationJSON;
import pl.szczepanik.silencio.core.IntegrityException;
import pl.szczepanik.silencio.core.Key;
import pl.szczepanik.silencio.core.Value;
import pl.szczepanik.silencio.utils.CommonUtility;
import pl.szczepanik.silencio.utils.IOUtility;

public class GeoLocationConverter
implements Converter {
    private static final String URL_ADDRESS_FORMAT = "http://maps.googleapis.com/maps/api/geocode/json?language=en&components=locality&latlng=%s,%s";
    private static final String OK_STATUS = "OK";
    private final Map<Object, String> values = new HashMap<Object, String>();
    private final Set<String> words = new LinkedHashSet<String>();
    private final ObjectMapper mapper = new ObjectMapper();
    private final Random locationGenerator = new Random();

    @Override
    public Value convert(Key key, Value value) {
        String newValue = this.values.get(value.getValue());
        if (newValue != null) {
            return new Value(newValue);
        }
        do {
            this.waitForNextLocation();
            GeoLocationJSON newLocation = this.generateNextLocation(this.generateNextUSLatitude(), this.generateNextUSLongitude());
            this.assertGeoIsValid(newLocation);
            newValue = newLocation.results[0].formattedAddress;
        } while (this.words.contains(newValue));
        this.values.put(value.getValue(), newValue);
        this.words.add(newValue);
        return new Value(newValue);
    }

    private void waitForNextLocation() {
        int waitTime = 150;
        CommonUtility.saveWait(150L);
    }

    private String generateNextUSLatitude() {
        int south = 32;
        int north = 50;
        int precision = 100;
        return this.locationGenerator.nextInt(18) + 32 + "." + this.locationGenerator.nextInt(100);
    }

    private String generateNextUSLongitude() {
        int east = -83;
        int west = -119;
        int precision = 100;
        return -(this.locationGenerator.nextInt(36) - -83) + "." + this.locationGenerator.nextInt(100);
    }

    private GeoLocationJSON generateNextLocation(String latitude, String longitude) {
        try {
            String url = String.format(URL_ADDRESS_FORMAT, latitude, longitude);
            String json = IOUtility.urlToString(new URL(url));
            if (StringUtils.isNotBlank((CharSequence)json)) {
                return (GeoLocationJSON)this.mapper.readValue(json, GeoLocationJSON.class);
            }
            throw new IntegrityException(String.format("URL '%s' returned empty content!", url));
        }
        catch (IOException e) {
            throw new IntegrityException(e.getMessage());
        }
    }

    @Override
    public void init() {
        this.values.clear();
        this.words.clear();
    }

    private void assertGeoIsValid(GeoLocationJSON location) {
        if (!OK_STATUS.equals(location.status)) {
            throw new IntegrityException(String.format("Result status is '%s' but expected '%s'", location.status, OK_STATUS));
        }
    }
}

