/*
 * Decompiled with CFR 0.152.
 */
package pl.szczepanik.silencio.converters;

import java.net.URL;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.Map;
import java.util.Set;
import org.apache.commons.lang3.StringUtils;
import pl.szczepanik.silencio.api.Converter;
import pl.szczepanik.silencio.core.IntegrityException;
import pl.szczepanik.silencio.core.Key;
import pl.szczepanik.silencio.core.Value;
import pl.szczepanik.silencio.utils.IOUtility;

public class WikipediaConverter
implements Converter {
    private static final String URL_ADDRESS = "https://en.m.wikipedia.org/wiki/Special:Random";
    private final URL url = IOUtility.createURL("https://en.m.wikipedia.org/wiki/Special:Random");
    private final Map<Object, String> values = new HashMap<Object, String>();
    private final Set<String> words = new LinkedHashSet<String>();

    @Override
    public Value convert(Key key, Value value) {
        String newValue = this.values.get(value.getValue());
        if (newValue != null) {
            return new Value(newValue);
        }
        while (this.words.contains(newValue = this.generateNextString())) {
        }
        this.values.put(value.getValue(), newValue);
        this.words.add(newValue);
        return new Value(newValue);
    }

    private String generateNextString() {
        String startPattern = "<h1 id=\"section_0\">";
        String endPattern = "</h1>";
        String page = IOUtility.urlToString(this.url);
        String title = StringUtils.substringBetween((String)page, (String)"<h1 id=\"section_0\">", (String)"</h1>");
        if (StringUtils.isBlank((CharSequence)title)) {
            throw new IntegrityException("Could not find header pattern for page: " + page);
        }
        String rawTitle = title.replaceFirst("<i>(.+)</i>", "$1");
        return rawTitle.replaceAll("[^\\d\\w]", " ").trim();
    }

    @Override
    public void init() {
        this.values.clear();
        this.words.clear();
    }
}

