/*
 * Decompiled with CFR 0.152.
 */
package pl.szczepanik.silencio.decisions;

import java.util.regex.Pattern;
import pl.szczepanik.silencio.api.Decision;
import pl.szczepanik.silencio.core.Key;
import pl.szczepanik.silencio.core.Value;

public class MatcherDecision
implements Decision {
    private final Pattern keyPattern;
    private final Pattern valuePattern;

    public MatcherDecision(String keyPattern, String valuePattern) {
        this.keyPattern = this.createPattern(keyPattern);
        this.valuePattern = this.createPattern(valuePattern);
    }

    public MatcherDecision(String valuePattern) {
        this(null, valuePattern);
    }

    private Pattern createPattern(String pattern) {
        if (pattern == null) {
            return null;
        }
        return Pattern.compile(pattern);
    }

    @Override
    public boolean decide(Key key, Value value) {
        boolean shouldConvert = true;
        if (key.getKey() != null && this.keyPattern != null) {
            shouldConvert &= this.keyPattern.matcher(key.getKey()).matches();
        }
        if (value.getValue() != null && this.valuePattern != null) {
            shouldConvert &= this.valuePattern.matcher(value.getValue().toString()).matches();
        }
        return shouldConvert;
    }
}

