/*
 * Decompiled with CFR 0.152.
 */
package pl.szczepanik.silencio.processors;

import com.fasterxml.jackson.core.type.TypeReference;
import com.fasterxml.jackson.databind.DeserializationFeature;
import com.fasterxml.jackson.databind.ObjectMapper;
import com.fasterxml.jackson.databind.ObjectWriter;
import com.fasterxml.jackson.databind.SerializationFeature;
import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import java.util.Map;
import pl.szczepanik.silencio.api.Format;
import pl.szczepanik.silencio.core.ProcessorException;
import pl.szczepanik.silencio.processors.AbstractProcessor;
import pl.szczepanik.silencio.processors.visitors.JSONVisitor;

public class JSONProcessor
extends AbstractProcessor {
    private final ObjectMapper mapper;
    private Map<String, Object> jsonStructure;
    private final JSONVisitor visitor = new JSONVisitor();

    public JSONProcessor() {
        super(Format.JSON);
        this.mapper = new ObjectMapper();
        this.mapper.enable(DeserializationFeature.USE_BIG_DECIMAL_FOR_FLOATS);
    }

    @Override
    public void realLoad(Reader reader) {
        try {
            this.jsonStructure = (Map)this.mapper.readValue(reader, (TypeReference)new TypeReference<Map<String, Object>>(){});
        }
        catch (IOException e) {
            throw new ProcessorException(e);
        }
    }

    @Override
    public void realProcess() {
        this.visitor.setConfiguration(this.configuration);
        this.visitor.processJSON(this.jsonStructure);
    }

    @Override
    public void realWrite(Writer writer) {
        ObjectWriter objectWriter = this.mapper.writer().with(SerializationFeature.INDENT_OUTPUT);
        try {
            objectWriter.writeValue(writer, this.jsonStructure);
        }
        catch (IOException e) {
            throw new ProcessorException(e);
        }
    }
}

