/*
 * Decompiled with CFR 0.152.
 */
package pl.szczepanik.silencio.processors;

import java.io.IOException;
import java.io.Reader;
import java.io.Writer;
import javax.xml.parsers.DocumentBuilder;
import javax.xml.parsers.DocumentBuilderFactory;
import javax.xml.parsers.ParserConfigurationException;
import javax.xml.transform.Transformer;
import javax.xml.transform.TransformerException;
import javax.xml.transform.TransformerFactory;
import javax.xml.transform.dom.DOMSource;
import javax.xml.transform.stream.StreamResult;
import org.w3c.dom.Document;
import org.w3c.dom.Element;
import org.xml.sax.InputSource;
import org.xml.sax.SAXException;
import pl.szczepanik.silencio.api.Format;
import pl.szczepanik.silencio.core.ProcessorException;
import pl.szczepanik.silencio.processors.AbstractProcessor;
import pl.szczepanik.silencio.processors.visitors.XMLVisitor;

public class XMLProcessor
extends AbstractProcessor {
    private final XMLVisitor visitor = new XMLVisitor();
    private Document document = null;

    public XMLProcessor() {
        super(Format.XML);
    }

    @Override
    public void realLoad(Reader reader) {
        DocumentBuilderFactory factory = DocumentBuilderFactory.newInstance();
        try {
            DocumentBuilder builder = factory.newDocumentBuilder();
            this.document = builder.parse(new InputSource(reader));
        }
        catch (IOException | ParserConfigurationException | SAXException e) {
            throw new ProcessorException(e);
        }
    }

    @Override
    public void realProcess() {
        this.visitor.setConfiguration(this.configuration);
        Element rootElement = this.document.getDocumentElement();
        rootElement.normalize();
        this.visitor.processXML(rootElement);
    }

    @Override
    public void realWrite(Writer writer) {
        TransformerFactory transformerFactory = TransformerFactory.newInstance();
        try {
            Transformer transformer = transformerFactory.newTransformer();
            DOMSource source = new DOMSource(this.document);
            StreamResult result = new StreamResult(writer);
            transformer.transform(source, result);
        }
        catch (TransformerException e) {
            throw new ProcessorException(e);
        }
    }
}

