/*
 * Decompiled with CFR 0.152.
 */
package pl.szczepanik.silencio.processors.visitors;

import pl.szczepanik.silencio.api.Converter;
import pl.szczepanik.silencio.api.Decision;
import pl.szczepanik.silencio.core.Configuration;
import pl.szczepanik.silencio.core.Execution;
import pl.szczepanik.silencio.core.Key;
import pl.szczepanik.silencio.core.Value;

public abstract class AbstractVisitor {
    static final String EXCEPTION_MESSAGE_INVALID_VALUE_TYPE = "Excepcted pure value, not packed into Value object.";
    private Configuration configuration;

    public void setConfiguration(Configuration configuration) {
        this.configuration = configuration;
    }

    protected Value processValue(Key key, Object value) {
        if (value instanceof Value) {
            throw new IllegalArgumentException(EXCEPTION_MESSAGE_INVALID_VALUE_TYPE);
        }
        Value newValue = new Value(value);
        for (Execution execution : this.configuration.getExecutions()) {
            boolean shouldConvert = true;
            for (Decision decision : execution.getDecisions()) {
                if (!(shouldConvert &= decision.decide(key, newValue))) break;
            }
            if (!shouldConvert) continue;
            for (Converter converter : execution.getConverters()) {
                newValue = converter.convert(key, newValue);
            }
        }
        return newValue;
    }
}

