/*
 * Decompiled with CFR 0.152.
 */
package pl.szczepanik.silencio.processors.visitors;

import org.apache.commons.lang3.StringUtils;
import org.w3c.dom.Element;
import org.w3c.dom.NamedNodeMap;
import org.w3c.dom.Node;
import org.w3c.dom.NodeList;
import pl.szczepanik.silencio.core.Key;
import pl.szczepanik.silencio.core.ProcessorException;
import pl.szczepanik.silencio.core.Value;
import pl.szczepanik.silencio.processors.visitors.AbstractVisitor;

public class XMLVisitor
extends AbstractVisitor {
    static final String EXCEPTION_MESSAGE_NODE_TYPE_UNSUPPORTED = "Node with type %d, name '%s' and value '%s' is not supported";

    public void processXML(Element rootElement) {
        this.processAttributes(rootElement.getAttributes());
        this.processNodes(rootElement.getChildNodes());
    }

    private void processNodes(NodeList nodeList) {
        for (int i = 0; i < nodeList.getLength(); ++i) {
            Node node = nodeList.item(i);
            this.processNode(node);
            this.processAttributes(node.getAttributes());
            this.processNodes(node.getChildNodes());
        }
    }

    private void processAttributes(NamedNodeMap attributes) {
        int attributeLength;
        int n = attributeLength = attributes == null ? 0 : attributes.getLength();
        if (attributeLength != 0) {
            for (int i = 0; i < attributeLength; ++i) {
                this.processNode(attributes.item(i));
            }
        }
    }

    private void processNode(Node node) {
        node.normalize();
        short type = node.getNodeType();
        switch (type) {
            case 1: 
            case 2: {
                this.convertNodeIfNeeded(node, node.getNodeName());
                break;
            }
            case 3: {
                this.convertNodeIfNeeded(node, node.getParentNode().getNodeName());
                break;
            }
            default: {
                throw new ProcessorException(String.format(EXCEPTION_MESSAGE_NODE_TYPE_UNSUPPORTED, type, node.getNodeName(), node.getNodeValue()));
            }
        }
    }

    private void convertNodeIfNeeded(Node node, String key) {
        if (this.shouldConvert(node)) {
            String pureValue = StringUtils.trim((String)node.getNodeValue());
            Value newValue = this.processValue(new Key(key), pureValue);
            node.setNodeValue(newValue.getValue().toString());
        }
    }

    private boolean shouldConvert(Node node) {
        return StringUtils.isNotBlank((CharSequence)StringUtils.trim((String)node.getNodeValue()));
    }
}

