/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.session;

import java.nio.charset.StandardCharsets;
import java.util.Base64;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import ro.pippo.session.Encryptor;

public class BaseEncryptor
implements Encryptor {
    private final String algorithm;

    public BaseEncryptor(String algorithm) {
        this.algorithm = algorithm;
    }

    @Override
    public String encrypt(String data, String key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), this.algorithm);
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(1, secretKey);
        byte[] encrypted = cipher.doFinal(data.getBytes(StandardCharsets.UTF_8));
        return Base64.getEncoder().encodeToString(encrypted);
    }

    @Override
    public String decrypt(String data, String key) throws Exception {
        SecretKeySpec secretKey = new SecretKeySpec(key.getBytes(StandardCharsets.UTF_8), this.algorithm);
        Cipher cipher = Cipher.getInstance(this.algorithm);
        cipher.init(2, secretKey);
        byte[] decoded = Base64.getDecoder().decode(data);
        return new String(cipher.doFinal(decoded), StandardCharsets.UTF_8);
    }
}

