/*
 * Decompiled with CFR 0.152.
 */
package ro.pippo.session;

import ro.pippo.core.PippoRuntimeException;
import ro.pippo.core.util.CryptoUtils;
import ro.pippo.session.DefaultEncryptor;
import ro.pippo.session.Encryptor;
import ro.pippo.session.SerializationSessionDataTranscoder;
import ro.pippo.session.SessionData;
import ro.pippo.session.SessionDataTranscoder;

public class EncryptedSessionDataTranscoder
implements SessionDataTranscoder {
    private static final String CHECKSUM_KEY = "_cs";
    private final String secretKey;
    private final String hmacSHA1Key;
    private final Encryptor encryptor;
    private final SessionDataTranscoder transcoder;

    private EncryptedSessionDataTranscoder(String secretKey, String hmacSHA1Key, SessionDataTranscoder transcoder, Encryptor encryptor) {
        this.secretKey = secretKey;
        this.hmacSHA1Key = hmacSHA1Key;
        this.transcoder = transcoder;
        this.encryptor = encryptor;
    }

    @Override
    public String encode(SessionData sessionData) {
        try {
            String checksum = this.checksumSessionData(sessionData);
            sessionData.put(CHECKSUM_KEY, checksum);
            String data = this.transcoder.encode(sessionData);
            return this.encryptor.encrypt(data, this.secretKey);
        }
        catch (Exception ex) {
            throw new PippoRuntimeException((Throwable)ex);
        }
    }

    @Override
    public SessionData decode(String data) {
        try {
            data = this.encryptor.decrypt(data, this.secretKey);
            SessionData sessionData = this.transcoder.decode(data);
            return this.isValidSessionData(sessionData) ? sessionData : null;
        }
        catch (Exception ex) {
            throw new PippoRuntimeException((Throwable)ex);
        }
    }

    protected String checksumSessionData(SessionData sessionData) {
        String data = this.transcoder.encode(sessionData);
        return CryptoUtils.getHmacSHA1((String)data, (String)this.hmacSHA1Key);
    }

    protected boolean isValidSessionData(SessionData sessionData) {
        String checksum = (String)sessionData.get(CHECKSUM_KEY);
        sessionData.remove(CHECKSUM_KEY);
        return checksum.equals(this.checksumSessionData(sessionData));
    }

    public static class Builder {
        private String secretKey;
        private String hmacSHA1Key;
        private Encryptor encryptor;
        private SessionDataTranscoder transcoder;

        public Builder secretKey(String secretKey) {
            this.secretKey = secretKey;
            return this;
        }

        public Builder hmacSHA1Key(String hmacSHA1Key) {
            this.hmacSHA1Key = hmacSHA1Key;
            return this;
        }

        public Builder encryptor(Encryptor encryptor) {
            this.encryptor = encryptor;
            return this;
        }

        public Builder transcoder(SessionDataTranscoder transcoder) {
            this.transcoder = transcoder;
            return this;
        }

        public EncryptedSessionDataTranscoder build() {
            if (this.secretKey == null) {
                throw new PippoRuntimeException("secretKey is required", new Object[0]);
            }
            if (this.hmacSHA1Key == null) {
                this.hmacSHA1Key = this.secretKey;
            }
            if (this.encryptor == null) {
                this.encryptor = new DefaultEncryptor();
            }
            if (this.transcoder == null) {
                this.transcoder = new SerializationSessionDataTranscoder();
            }
            return new EncryptedSessionDataTranscoder(this.secretKey, this.hmacSHA1Key, this.transcoder, this.encryptor);
        }
    }
}

