/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import java.math.BigDecimal;
import java.math.BigInteger;
import java.sql.JDBCType;
import java.sql.Timestamp;
import java.time.LocalDate;
import java.time.LocalDateTime;
import java.time.format.DateTimeFormatter;
import java.util.Date;
import ru.yandex.clickhouse.jdbcbridge.core.DataType;

public interface DataTypeConverter {
    public static final String M_TYPE_TEXT = "type text";
    public static final String M_TYPE_NUMBER = "type number";
    public static final String M_TYPE_DATE = "type date";
    public static final String M_TYPE_DATETIME = "type datetime";
    public static final String M_FACET_INT8 = "Int8.Type";
    public static final String M_FACET_INT16 = "Int16.Type";
    public static final String M_FACET_INT32 = "Int32.Type";
    public static final String M_FACET_INT64 = "Int64.Type";
    public static final String M_FACET_SINGLE = "Single.Type";
    public static final String M_FACET_DOUBLE = "Double.Type";

    default public <T> T as(Class<T> type, Object value) {
        String str;
        int len;
        Object result = Boolean.class.equals(type) ? (value instanceof Boolean ? value : (value instanceof Number ? Boolean.valueOf(((Number)value).intValue() != 0) : Boolean.valueOf(Boolean.parseBoolean(String.valueOf(value))))) : (Byte.class.equals(type) ? (value instanceof Boolean ? Byte.valueOf((Boolean)value != false ? (byte)0 : 1) : (value instanceof Number ? Byte.valueOf(((Number)value).byteValue()) : Byte.valueOf(Byte.parseByte(String.valueOf(value))))) : (Short.class.equals(type) ? (value instanceof Boolean ? Short.valueOf((Boolean)value != false ? (short)0 : 1) : (value instanceof Number ? Short.valueOf(((Number)value).shortValue()) : Short.valueOf(Short.parseShort(String.valueOf(value))))) : (Integer.class.equals(type) ? (value instanceof Boolean ? Integer.valueOf((Boolean)value != false ? 0 : 1) : (value instanceof Number ? Integer.valueOf(((Number)value).intValue()) : Integer.valueOf(Integer.parseInt(String.valueOf(value))))) : (Long.class.equals(type) ? (value instanceof Boolean ? Long.valueOf((Boolean)value != false ? 0L : 1L) : (value instanceof Number ? Long.valueOf(((Number)value).longValue()) : Long.valueOf(Long.parseLong(String.valueOf(value))))) : (Float.class.equals(type) ? (value instanceof Boolean ? Float.valueOf((Boolean)value != false ? 0.0f : 1.0f) : (value instanceof Number ? Float.valueOf(((Number)value).floatValue()) : Float.valueOf(Float.parseFloat(String.valueOf(value))))) : (Double.class.equals(type) ? (value instanceof Boolean ? Double.valueOf((Boolean)value != false ? 0.0 : 1.0) : (value instanceof Number ? Double.valueOf(((Number)value).doubleValue()) : Double.valueOf(Double.parseDouble(String.valueOf(value))))) : (BigInteger.class.equals(type) ? (value instanceof Boolean ? ((Boolean)value != false ? BigInteger.ZERO : BigInteger.ONE) : (value instanceof BigInteger ? value : new BigInteger(String.valueOf(value)))) : (BigDecimal.class.equals(type) ? (value instanceof Boolean ? ((Boolean)value != false ? BigDecimal.ZERO : BigDecimal.ONE) : (value instanceof BigDecimal ? value : new BigDecimal(String.valueOf(value)))) : (Date.class.equals(type) ? (value instanceof Boolean ? new Date((Boolean)value != false ? 0L : 1L) : (value instanceof Number ? new Date(((Number)value).longValue()) : (value instanceof String ? ((len = (str = (String)value).length()) == 10 ? java.sql.Date.valueOf(LocalDate.parse(str, DateTimeFormatter.ISO_LOCAL_DATE)) : (len >= 10 && len <= 16 ? java.sql.Date.valueOf(LocalDate.parse(str, DateTimeFormatter.ISO_DATE)) : (len == 19 ? Timestamp.valueOf(LocalDateTime.parse(str, DateTimeFormatter.ISO_LOCAL_DATE_TIME)) : (len > 19 ? Timestamp.valueOf(LocalDateTime.parse(str, DateTimeFormatter.ISO_DATE_TIME)) : java.sql.Date.valueOf(LocalDate.parse(str, DateTimeFormatter.BASIC_ISO_DATE)))))) : value))) : (String.class.equals(type) ? String.valueOf(value) : value))))))))));
        return (T)result;
    }

    public DataType from(JDBCType var1, String var2, int var3, int var4, boolean var5);

    public DataType from(Object var1);

    default public String toPowerQueryType(DataType type) {
        return this.toMType(type);
    }

    default public String toMType(DataType type) {
        String mType = M_TYPE_TEXT;
        switch (type) {
            case Bool: 
            case Int8: {
                mType = M_FACET_INT8;
                break;
            }
            case UInt8: 
            case Int16: {
                mType = M_FACET_INT16;
                break;
            }
            case UInt16: 
            case Int32: {
                mType = M_FACET_INT32;
                break;
            }
            case UInt32: 
            case Int64: {
                mType = M_FACET_INT64;
                break;
            }
            case Float32: {
                mType = M_FACET_SINGLE;
                break;
            }
            case Float64: {
                mType = M_FACET_DOUBLE;
                break;
            }
            case UInt64: 
            case Decimal: 
            case Decimal32: 
            case Decimal64: 
            case Decimal128: 
            case Decimal256: {
                mType = M_TYPE_NUMBER;
                break;
            }
            case Date: {
                mType = M_TYPE_DATE;
                break;
            }
            case DateTime: 
            case DateTime64: {
                mType = M_TYPE_DATETIME;
                break;
            }
        }
        return mType;
    }
}

