/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import io.vertx.core.json.JsonObject;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Objects;
import java.util.TreeMap;
import ru.yandex.clickhouse.jdbcbridge.core.TypedParameter;
import ru.yandex.clickhouse.jdbcbridge.core.Utils;

public class QueryParameters {
    public static final String PARAM_BATCH_SIZE = "batch_size";
    public static final String PARAM_CUSTOM_COLUMNS = "custom_columns";
    public static final String PARAM_DATASOURCE_COLUMN = "datasource_column";
    public static final String PARAM_FETCH_SIZE = "fetch_size";
    public static final String PARAM_MAX_ROWS = "max_rows";
    public static final String PARAM_MUTATION = "mutation";
    public static final String PARAM_NO_CACHE = "no_cache";
    public static final String PARAM_NULL_AS_DEFAULT = "null_as_default";
    public static final String PARAM_OFFSET = "offset";
    public static final String PARAM_POSITION = "position";
    public static final String PARAM_TIMEOUT = "timeout";
    public static final String PARAM_USE_DATETIME = "use_datetime";
    public static final String PARAM_DEBUG = "debug";
    public static final int DEFAULT_BATCH_SIZE = 100;
    public static final int DEFAULT_FETCH_SIZE = 1000;
    public static final int DEFAULT_MAX_ROWS = 0;
    public static final int DEFAULT_OFFSET = 0;
    public static final int DEFAULT_POSITION = 0;
    public static final int DEFAULT_TIMEOUT = -1;
    private final TypedParameter<Integer> batchSize;
    private final TypedParameter<Boolean> customColumns;
    private final TypedParameter<Boolean> datasourceColumn;
    private final TypedParameter<Integer> fetchSize;
    private final TypedParameter<Integer> maxRows;
    private final TypedParameter<Boolean> mutation;
    private final TypedParameter<Boolean> noCache;
    private final TypedParameter<Boolean> nullAsDefault;
    private final TypedParameter<Integer> offset;
    private final TypedParameter<Integer> position;
    private final TypedParameter<Integer> timeout;
    private final TypedParameter<Boolean> debug;
    private final Map<String, TypedParameter<?>> params = new TreeMap();

    public QueryParameters() {
        this.batchSize = new TypedParameter<Integer>(Integer.class, PARAM_BATCH_SIZE, 100);
        Utils.addTypedParameter(this.params, this.batchSize);
        this.customColumns = new TypedParameter<Boolean>(Boolean.class, PARAM_CUSTOM_COLUMNS, false);
        Utils.addTypedParameter(this.params, this.customColumns);
        this.datasourceColumn = new TypedParameter<Boolean>(Boolean.class, PARAM_DATASOURCE_COLUMN, false);
        Utils.addTypedParameter(this.params, this.datasourceColumn);
        this.fetchSize = new TypedParameter<Integer>(Integer.class, PARAM_FETCH_SIZE, 1000);
        Utils.addTypedParameter(this.params, this.fetchSize);
        this.maxRows = new TypedParameter<Integer>(Integer.class, PARAM_MAX_ROWS, 0);
        Utils.addTypedParameter(this.params, this.maxRows);
        this.mutation = new TypedParameter<Boolean>(Boolean.class, PARAM_MUTATION, false);
        Utils.addTypedParameter(this.params, this.mutation);
        this.noCache = new TypedParameter<Boolean>(Boolean.class, PARAM_NO_CACHE, false);
        Utils.addTypedParameter(this.params, this.noCache);
        this.nullAsDefault = new TypedParameter<Boolean>(Boolean.class, PARAM_NULL_AS_DEFAULT, false);
        Utils.addTypedParameter(this.params, this.nullAsDefault);
        this.offset = new TypedParameter<Integer>(Integer.class, PARAM_OFFSET, 0);
        Utils.addTypedParameter(this.params, this.offset);
        this.position = new TypedParameter<Integer>(Integer.class, PARAM_POSITION, 0);
        Utils.addTypedParameter(this.params, this.position);
        this.timeout = new TypedParameter<Integer>(Integer.class, PARAM_TIMEOUT, -1);
        Utils.addTypedParameter(this.params, this.timeout);
        this.debug = new TypedParameter<Boolean>(Boolean.class, PARAM_DEBUG, false);
        Utils.addTypedParameter(this.params, this.debug);
    }

    public QueryParameters(String uri) {
        this();
        this.merge(uri);
    }

    public QueryParameters(JsonObject ... params) {
        this();
        for (JsonObject parameters : params) {
            this.merge(parameters);
        }
    }

    public QueryParameters merge(QueryParameters p) {
        if (p != null) {
            for (TypedParameter<?> tp : p.params.values()) {
                TypedParameter<?> x = this.params.get(tp.getName());
                if (x == null) {
                    this.params.put(tp.getName(), tp);
                    continue;
                }
                if (x.getType() != tp.getType()) continue;
                x.merge(tp.getValue());
            }
        }
        return this;
    }

    public QueryParameters merge(JsonObject p) {
        if (p != null) {
            HashSet names = new HashSet(p.fieldNames());
            for (TypedParameter<?> tp : this.params.values()) {
                names.remove(tp.getName());
                if (PARAM_DEBUG.equals(tp.getName())) continue;
                tp.merge(p);
            }
            for (String name : names) {
                String value = Objects.toString(p.getValue(name));
                this.params.put(name, new TypedParameter<String>(String.class, name, value, value));
            }
        }
        return this;
    }

    public QueryParameters merge(String uri) {
        int index;
        int n = index = uri == null ? -1 : uri.indexOf(63);
        if (index >= 0 && uri.length() > index) {
            String query = uri.substring(index + 1);
            for (String param : Utils.splitByChar(query, '&')) {
                index = param.indexOf(61);
                if (index > 0) {
                    String key = param.substring(0, index);
                    String value = param.substring(index + 1);
                    TypedParameter<?> p = this.params.get(key);
                    if (p != null) {
                        p.merge(value);
                        continue;
                    }
                    this.params.put(key, new TypedParameter<String>(String.class, key, value, value));
                    continue;
                }
                TypedParameter<?> p = this.params.get(param);
                if (p == null || !(p.getDefaultValue() instanceof Boolean)) continue;
                p.merge(Boolean.TRUE.toString());
            }
        }
        return this;
    }

    public int getBatchSize() {
        return this.batchSize.getValue();
    }

    public int getFetchSize() {
        return this.fetchSize.getValue();
    }

    public int getMaxRows() {
        return this.maxRows.getValue();
    }

    public boolean isMutation() {
        return this.mutation.getValue();
    }

    public boolean doNotUseCache() {
        return this.noCache.getValue();
    }

    public boolean nullAsDefault() {
        return this.nullAsDefault.getValue();
    }

    public int getOffset() {
        return this.offset.getValue();
    }

    public int getPosition() {
        return this.position.getValue();
    }

    public int getTimeout() {
        return this.timeout.getValue();
    }

    public boolean showDatasourceColumn() {
        return this.datasourceColumn.getValue();
    }

    public boolean showCustomColumns() {
        return this.customColumns.getValue();
    }

    public boolean isDebug() {
        return this.debug.getValue();
    }

    public <T> T getParameterDefaultValue(String key, Class<T> type) {
        return (T)this.params.get(key).getDefaultValue();
    }

    public <T> T getParameterValue(String key, Class<T> type) {
        return (T)this.params.get(key).getValue();
    }

    public Map<String, String> asVariables() {
        HashMap<String, String> map = new HashMap<String, String>(this.params.size());
        for (TypedParameter<?> tp : this.params.values()) {
            Object value = tp.getValue();
            if (!(value instanceof String)) continue;
            map.put(tp.getName(), (String)value);
        }
        return map;
    }

    public String toQueryString() {
        StringBuilder sb = new StringBuilder();
        for (TypedParameter<?> p : this.params.values()) {
            sb.append('&').append(p.toKeyValuePairString());
        }
        if (sb.length() > 0) {
            sb.deleteCharAt(0);
        }
        return sb.toString();
    }

    public JsonObject toJson() {
        JsonObject obj = new JsonObject();
        for (Map.Entry<String, TypedParameter<?>> p : this.params.entrySet()) {
            obj.put(p.getKey(), String.valueOf(p.getValue().getValue()));
        }
        return obj;
    }
}

