/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import java.sql.JDBCType;
import ru.yandex.clickhouse.jdbcbridge.core.DataType;

public class DataTypeMapping {
    public static final String ANY_NATIVE_TYPE = "*";
    private final JDBCType fromJdbcType;
    private final String fromNativeType;
    private final DataType toType;

    private static JDBCType parse(String fromJdbcType) {
        JDBCType jdbcType = JDBCType.OTHER;
        if (fromJdbcType != null) {
            try {
                fromJdbcType = fromJdbcType.trim().toUpperCase();
                jdbcType = JDBCType.valueOf(fromJdbcType);
            }
            catch (RuntimeException runtimeException) {
                // empty catch block
            }
        }
        return jdbcType;
    }

    private static JDBCType parse(int fromJdbcType) {
        JDBCType jdbcType = JDBCType.OTHER;
        try {
            jdbcType = JDBCType.valueOf(fromJdbcType);
        }
        catch (RuntimeException runtimeException) {
            // empty catch block
        }
        return jdbcType;
    }

    public DataTypeMapping(String fromJdbcType, String fromNativeType, String toType) {
        this(DataTypeMapping.parse(fromJdbcType), fromNativeType, DataType.from(toType));
    }

    public DataTypeMapping(int fromJdbcType, String fromNativeType, DataType toType) {
        this(DataTypeMapping.parse(fromJdbcType), fromNativeType, toType);
    }

    public DataTypeMapping(JDBCType fromJdbcType, String fromNativeType, DataType toType) {
        this.fromJdbcType = fromJdbcType;
        this.fromNativeType = ANY_NATIVE_TYPE.equals(fromNativeType) ? ANY_NATIVE_TYPE : fromNativeType;
        this.toType = toType;
    }

    public JDBCType getSourceJdbcType() {
        return this.fromJdbcType;
    }

    public String getSourceNativeType() {
        return this.fromNativeType;
    }

    public DataType getMappedType() {
        return this.toType;
    }

    public boolean accept(JDBCType jdbcType, String nativeType) {
        return this.fromNativeType != null ? ANY_NATIVE_TYPE == this.fromNativeType || this.fromNativeType.equals(nativeType) : this.fromJdbcType == jdbcType;
    }
}

