/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import io.vertx.core.json.JsonObject;
import java.math.BigDecimal;
import java.math.BigInteger;
import java.util.Iterator;
import java.util.Map;
import java.util.TreeMap;
import ru.yandex.clickhouse.jdbcbridge.core.DataType;
import ru.yandex.clickhouse.jdbcbridge.core.TypedParameter;
import ru.yandex.clickhouse.jdbcbridge.core.Utils;

public class DefaultValues {
    public static final String DEFAULT_UUID = "00000000-0000-0000-0000-000000000000";
    public final TypedParameter<Integer> Bool;
    public final TypedParameter<Integer> Int8;
    public final TypedParameter<Integer> Int16;
    public final TypedParameter<Integer> Int32;
    public final TypedParameter<Long> Int64;
    public final TypedParameter<BigInteger> Int128;
    public final TypedParameter<BigInteger> Int256;
    public final TypedParameter<Integer> UInt8;
    public final TypedParameter<Integer> UInt16;
    public final TypedParameter<Long> UInt32;
    public final TypedParameter<Long> UInt64;
    public final TypedParameter<BigInteger> UInt128;
    public final TypedParameter<BigInteger> UInt256;
    public final TypedParameter<Float> Float32;
    public final TypedParameter<Double> Float64;
    public final TypedParameter<Integer> Date;
    public final TypedParameter<Long> Datetime;
    public final TypedParameter<Long> Datetime64;
    public final TypedParameter<BigDecimal> Decimal;
    public final TypedParameter<BigDecimal> Decimal32;
    public final TypedParameter<BigDecimal> Decimal64;
    public final TypedParameter<BigDecimal> Decimal128;
    public final TypedParameter<BigDecimal> Decimal256;
    public final TypedParameter<Integer> Enum;
    public final TypedParameter<Integer> Enum8;
    public final TypedParameter<Integer> Enum16;
    public final TypedParameter<Integer> IPv4;
    public final TypedParameter<String> IPv6;
    public final TypedParameter<String> FixedStr;
    public final TypedParameter<String> Str;
    public final TypedParameter<String> UUID;
    private final Map<String, TypedParameter<?>> types = new TreeMap();

    public DefaultValues() {
        this.Bool = new TypedParameter<Integer>(Integer.class, DataType.Bool.name(), 0);
        Utils.addTypedParameter(this.types, this.Bool);
        this.Int8 = new TypedParameter<Integer>(Integer.class, DataType.Int8.name(), 0);
        Utils.addTypedParameter(this.types, this.Int8);
        this.Int16 = new TypedParameter<Integer>(Integer.class, DataType.Int16.name(), 0);
        Utils.addTypedParameter(this.types, this.Int16);
        this.Int32 = new TypedParameter<Integer>(Integer.class, DataType.Int32.name(), 0);
        Utils.addTypedParameter(this.types, this.Int32);
        this.Int64 = new TypedParameter<Long>(Long.class, DataType.Int64.name(), 0L);
        Utils.addTypedParameter(this.types, this.Int64);
        this.Int128 = new TypedParameter<BigInteger>(BigInteger.class, DataType.Int128.name(), BigInteger.ZERO);
        Utils.addTypedParameter(this.types, this.Int128);
        this.Int256 = new TypedParameter<BigInteger>(BigInteger.class, DataType.Int256.name(), BigInteger.ZERO);
        Utils.addTypedParameter(this.types, this.Int256);
        this.UInt8 = new TypedParameter<Integer>(Integer.class, DataType.UInt8.name(), 0);
        Utils.addTypedParameter(this.types, this.UInt8);
        this.UInt16 = new TypedParameter<Integer>(Integer.class, DataType.UInt16.name(), 0);
        Utils.addTypedParameter(this.types, this.UInt16);
        this.UInt32 = new TypedParameter<Long>(Long.class, DataType.UInt32.name(), 0L);
        Utils.addTypedParameter(this.types, this.UInt32);
        this.UInt64 = new TypedParameter<Long>(Long.class, DataType.UInt64.name(), 0L);
        Utils.addTypedParameter(this.types, this.UInt64);
        this.UInt128 = new TypedParameter<BigInteger>(BigInteger.class, DataType.UInt128.name(), BigInteger.ZERO);
        Utils.addTypedParameter(this.types, this.UInt128);
        this.UInt256 = new TypedParameter<BigInteger>(BigInteger.class, DataType.UInt256.name(), BigInteger.ZERO);
        Utils.addTypedParameter(this.types, this.UInt256);
        this.Float32 = new TypedParameter<Float>(Float.class, DataType.Float32.name(), Float.valueOf(0.0f));
        Utils.addTypedParameter(this.types, this.Float32);
        this.Float64 = new TypedParameter<Double>(Double.class, DataType.Float64.name(), 0.0);
        Utils.addTypedParameter(this.types, this.Float64);
        this.Date = new TypedParameter<Integer>(Integer.class, DataType.Date.name(), 1);
        Utils.addTypedParameter(this.types, this.Date);
        this.Datetime = new TypedParameter<Long>(Long.class, DataType.DateTime.name(), 1L);
        Utils.addTypedParameter(this.types, this.Datetime);
        this.Datetime64 = new TypedParameter<Long>(Long.class, DataType.DateTime64.name(), 1000L);
        Utils.addTypedParameter(this.types, this.Datetime64);
        this.Decimal = new TypedParameter<BigDecimal>(BigDecimal.class, DataType.Decimal.name(), BigDecimal.ZERO);
        Utils.addTypedParameter(this.types, this.Decimal);
        this.Decimal32 = new TypedParameter<BigDecimal>(BigDecimal.class, DataType.Decimal32.name(), BigDecimal.ZERO);
        Utils.addTypedParameter(this.types, this.Decimal32);
        this.Decimal64 = new TypedParameter<BigDecimal>(BigDecimal.class, DataType.Decimal64.name(), BigDecimal.ZERO);
        Utils.addTypedParameter(this.types, this.Decimal64);
        this.Decimal128 = new TypedParameter<BigDecimal>(BigDecimal.class, DataType.Decimal128.name(), BigDecimal.ZERO);
        Utils.addTypedParameter(this.types, this.Decimal128);
        this.Decimal256 = new TypedParameter<BigDecimal>(BigDecimal.class, DataType.Decimal256.name(), BigDecimal.ZERO);
        Utils.addTypedParameter(this.types, this.Decimal256);
        this.Enum = new TypedParameter<Integer>(Integer.class, DataType.Enum.name(), 0);
        Utils.addTypedParameter(this.types, this.Enum);
        this.Enum8 = new TypedParameter<Integer>(Integer.class, DataType.Enum8.name(), 0);
        Utils.addTypedParameter(this.types, this.Enum8);
        this.Enum16 = new TypedParameter<Integer>(Integer.class, DataType.Enum16.name(), 0);
        Utils.addTypedParameter(this.types, this.Enum16);
        this.IPv4 = new TypedParameter<Integer>(Integer.class, DataType.IPv4.name(), 0);
        Utils.addTypedParameter(this.types, this.IPv4);
        this.IPv6 = new TypedParameter<String>(String.class, DataType.IPv6.name(), "");
        Utils.addTypedParameter(this.types, this.IPv6);
        this.FixedStr = new TypedParameter<String>(String.class, DataType.FixedStr.name(), "");
        Utils.addTypedParameter(this.types, this.FixedStr);
        this.Str = new TypedParameter<String>(String.class, DataType.Str.name(), "");
        Utils.addTypedParameter(this.types, this.Str);
        this.UUID = new TypedParameter<String>(String.class, DataType.UUID.name(), DEFAULT_UUID);
        Utils.addTypedParameter(this.types, this.UUID);
    }

    public DefaultValues(JsonObject ... params) {
        this();
        for (JsonObject p : params) {
            this.merge(p);
        }
    }

    public DefaultValues merge(JsonObject p) {
        if (p != null) {
            for (Map.Entry entry : p) {
                String key = (String)entry.getKey();
                String name = DataType.from(key).name();
                TypedParameter<?> tp = this.types.get(name);
                if (tp == null) continue;
                tp.merge(p, key);
            }
        }
        return this;
    }

    public TypedParameter<?> getTypedValue(DataType type) {
        TypedParameter<?> p = this.types.get(type.name());
        if (p == null) {
            throw new IllegalArgumentException("unsupported type: " + type.name());
        }
        return p;
    }

    public String asJsonString() {
        JsonObject obj = new JsonObject();
        Iterator<Map.Entry<String, TypedParameter<?>>> iterator = this.types.entrySet().iterator();
        while (iterator.hasNext()) {
            Object value;
            Map.Entry<String, TypedParameter<?>> t;
            obj.put(t.getKey(), (value = (t = iterator.next()).getValue().getDefaultValue()) == null ? null : String.valueOf(value));
        }
        return obj.toString();
    }
}

