/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import io.vertx.core.json.JsonArray;
import io.vertx.core.json.JsonObject;
import java.util.Collections;
import java.util.Date;
import java.util.LinkedHashSet;
import java.util.Objects;
import java.util.Set;
import ru.yandex.clickhouse.jdbcbridge.core.UsageStats;
import ru.yandex.clickhouse.jdbcbridge.core.Utils;

public abstract class ManagedEntity {
    protected static final String CONF_ID = "id";
    protected static final String CONF_ALIASES = "aliases";
    protected static final String CONF_TYPE = "type";
    protected final Set<String> aliases = new LinkedHashSet<String>();
    protected final Date createDateTime = new Date();
    protected final String digest;
    protected final String id;
    protected final String type;

    protected ManagedEntity(String id, JsonObject config) {
        this.digest = Utils.digest(config);
        this.id = id == null && config != null ? config.getString(CONF_ID) : id;
        String defaultType = this.getClass().getSimpleName();
        if (config != null) {
            this.type = config.getString(CONF_TYPE, defaultType);
            JsonArray array = config.getJsonArray(CONF_ALIASES);
            if (array != null) {
                for (Object item : array) {
                    if (!(item instanceof String) || "".equals(item)) continue;
                    this.aliases.add((String)item);
                }
                this.aliases.remove(id);
            }
        } else {
            this.type = defaultType;
        }
    }

    public void validate() {
    }

    public final String getId() {
        return this.id;
    }

    public final Set<String> getAliases() {
        return Collections.unmodifiableSet(this.aliases);
    }

    public final Date getCreationDateTime() {
        return this.createDateTime;
    }

    public String getType() {
        return Objects.requireNonNull(this.type);
    }

    public final boolean isDifferentFrom(JsonObject config) {
        return this.digest == null || this.digest.isEmpty() || !this.digest.equals(Utils.digest(config));
    }

    public abstract UsageStats getUsage(String var1);
}

