/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.core;

import io.vertx.core.json.JsonObject;
import java.util.Objects;
import ru.yandex.clickhouse.jdbcbridge.core.ManagedEntity;
import ru.yandex.clickhouse.jdbcbridge.core.Repository;
import ru.yandex.clickhouse.jdbcbridge.core.TableDefinition;
import ru.yandex.clickhouse.jdbcbridge.core.UsageStats;

public class NamedSchema
extends ManagedEntity {
    protected static final String CONF_COLUMNS = "columns";
    private final TableDefinition columns;

    public static NamedSchema newInstance(Object ... args) {
        if (Objects.requireNonNull(args).length < 2) {
            throw new IllegalArgumentException("In order to create named schema, you need to specify at least ID and repository.");
        }
        String id = (String)args[0];
        Repository manager = (Repository)Objects.requireNonNull(args[1]);
        JsonObject config = args.length > 2 ? (JsonObject)args[2] : null;
        NamedSchema schema = new NamedSchema(id, manager, config);
        schema.validate();
        return schema;
    }

    public NamedSchema(String id, Repository<? extends NamedSchema> repo, JsonObject config) {
        super(id, Objects.requireNonNull(config));
        this.columns = TableDefinition.fromJson(config.getJsonArray(CONF_COLUMNS));
    }

    public boolean hasColumn() {
        return this.columns != null && this.columns.hasColumn();
    }

    public TableDefinition getColumns() {
        return this.columns;
    }

    @Override
    public UsageStats getUsage(String idOrAlias) {
        return null;
    }
}

