/*
 * Decompiled with CFR 0.152.
 */
package ru.yandex.clickhouse.jdbcbridge.impl;

import java.util.Iterator;
import java.util.List;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yandex.clickhouse.jdbcbridge.core.ByteBuffer;
import ru.yandex.clickhouse.jdbcbridge.core.ColumnDefinition;
import ru.yandex.clickhouse.jdbcbridge.core.DataSourceStats;
import ru.yandex.clickhouse.jdbcbridge.core.DataTableReader;
import ru.yandex.clickhouse.jdbcbridge.core.DataType;
import ru.yandex.clickhouse.jdbcbridge.core.DefaultValues;
import ru.yandex.clickhouse.jdbcbridge.core.ExtensionManager;
import ru.yandex.clickhouse.jdbcbridge.core.NamedDataSource;
import ru.yandex.clickhouse.jdbcbridge.core.QueryParameters;
import ru.yandex.clickhouse.jdbcbridge.core.Repository;
import ru.yandex.clickhouse.jdbcbridge.core.ResponseWriter;
import ru.yandex.clickhouse.jdbcbridge.core.TableDefinition;
import ru.yandex.clickhouse.jdbcbridge.core.UsageStats;
import ru.yandex.clickhouse.jdbcbridge.core.Utils;

public class ConfigDataSource
extends NamedDataSource {
    private static final Logger log = LoggerFactory.getLogger(ConfigDataSource.class);
    public static final String EXTENSION_NAME = "config";
    private static final String KWD_SHOW = "SHOW";
    private static final String KWD_DATASOURCES = "DATASOURCES";
    private static final String COL_NAME = "name";
    private static final String COL_IS_ALIAS = "is_alias";
    private static final String COL_INSTANCE = "instance";
    private static final String COL_CREATE_DATETIME = "create_datetime";
    private static final String COL_TYPE = "type";
    private static final String COL_PARAMETERS = "parameters";
    private static final String COL_DEFAULTS = "defaults";
    private static final String COL_CUSTOM_COLUMNS = "custom_columns";
    private static final String COL_CACHE_USAGE = "cache_usage";
    private static final String COL_POOL_USAGE = "pool_usage";
    private static final TableDefinition DATASOURCE_CONFIG_COLUMNS = new TableDefinition(new ColumnDefinition("name", DataType.Str, true, 0, 0, 0), new ColumnDefinition("is_alias", DataType.UInt8, true, 0, 0, 0), new ColumnDefinition("instance", DataType.Int32, true, 0, 0, 0), new ColumnDefinition("create_datetime", DataType.DateTime, true, 0, 0, 0), new ColumnDefinition("type", DataType.Str, true, 0, 0, 0), new ColumnDefinition("parameters", DataType.Str, true, 0, 0, 0), new ColumnDefinition("defaults", DataType.Str, true, 0, 0, 0), new ColumnDefinition("custom_columns", DataType.Str, true, 0, 0, 0), new ColumnDefinition("cache_usage", DataType.Str, true, 0, 0, 0), new ColumnDefinition("pool_usage", DataType.Str, true, 0, 0, 0));
    private final Repository<NamedDataSource> dataSourceRepo;

    public static void initialize(ExtensionManager manager) {
        Repository<NamedDataSource> dsRepo = manager.getRepositoryManager().getRepository(NamedDataSource.class);
        dsRepo.put("", new ConfigDataSource(dsRepo));
    }

    protected ConfigQuery parse(String query) {
        List<String> parsedQuery;
        int parts;
        ConfigQuery cq = new ConfigQuery();
        if (query != null && (parts = (parsedQuery = Utils.splitByChar(query, ' ', true)).size()) == 2 && KWD_SHOW.equalsIgnoreCase(cq.queryType = parsedQuery.get(0)) && KWD_DATASOURCES.equalsIgnoreCase(parsedQuery.get(1))) {
            cq.configType = KWD_DATASOURCES;
        }
        if (cq.configType == null) {
            throw new IllegalArgumentException("Invalid query [" + query + "], try SHOW DATASOURCES");
        }
        return cq;
    }

    protected ConfigDataSource(Repository<NamedDataSource> dataSourceRepo) {
        super(EXTENSION_NAME, dataSourceRepo, null);
        this.dataSourceRepo = dataSourceRepo;
    }

    @Override
    protected void writeQueryResult(String schema, String originalQuery, String loadedQuery, QueryParameters params, ColumnDefinition[] requestColumns, ColumnDefinition[] customColumns, DefaultValues defaultValues, ResponseWriter writer) {
        ConfigQuery cq = this.parse(loadedQuery);
        if (cq.configType != KWD_DATASOURCES) {
            return;
        }
        new DataSourceStatReader(this.dataSourceRepo.getUsageStats()).process(this.getId(), requestColumns, customColumns, DATASOURCE_CONFIG_COLUMNS.getColumns(), defaultValues, this.getTimeZone(), params, writer);
    }

    @Override
    public String getType() {
        return EXTENSION_NAME;
    }

    @Override
    protected TableDefinition inferTypes(String schema, String originalQuery, String loadedQuery, QueryParameters params) {
        this.parse(loadedQuery);
        return DATASOURCE_CONFIG_COLUMNS;
    }

    static class DataSourceStatReader
    implements DataTableReader {
        private final Iterator<UsageStats> stats;
        private DataSourceStats current = null;

        protected DataSourceStatReader(List<UsageStats> stats) {
            this.stats = stats.iterator();
        }

        @Override
        public boolean nextRow() {
            boolean hasNext = false;
            while (this.stats.hasNext()) {
                UsageStats usage = this.stats.next();
                if (usage instanceof DataSourceStats && !(this.current = (DataSourceStats)usage).getName().isEmpty()) {
                    hasNext = true;
                    break;
                }
                log.warn("Discard unsupported usage statistics: {}", (Object)usage);
            }
            return hasNext;
        }

        @Override
        public boolean isNull(int row, int column, ColumnDefinition metadata) {
            return false;
        }

        @Override
        public void read(int row, int column, ColumnDefinition metadata, ByteBuffer buffer) {
            switch (metadata.getName()) {
                case "name": {
                    buffer.writeString(this.current.getName());
                    break;
                }
                case "is_alias": {
                    buffer.writeBoolean(this.current.isAlias());
                    break;
                }
                case "instance": {
                    buffer.writeInt32(this.current.getInstance());
                    break;
                }
                case "create_datetime": {
                    buffer.writeDateTime(this.current.getCreateDateTime());
                    break;
                }
                case "type": {
                    buffer.writeString(this.current.getType());
                    break;
                }
                case "custom_columns": {
                    buffer.writeString(this.current.getCustomColumns());
                    break;
                }
                case "defaults": {
                    buffer.writeString(this.current.getDefaults());
                    break;
                }
                case "parameters": {
                    buffer.writeString(this.current.getParameters());
                    break;
                }
                case "cache_usage": {
                    buffer.writeString(this.current.getCacheUsage());
                    break;
                }
                case "pool_usage": {
                    buffer.writeString(this.current.getPoolUsage());
                    break;
                }
            }
        }
    }

    protected static class ConfigQuery {
        String configType;
        String queryType;

        protected ConfigQuery() {
        }
    }
}

