/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.api;

import java.time.Duration;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class EnqueueParams<PayloadT> {
    @Nullable
    private PayloadT payload;
    @Nonnull
    private Duration executionDelay = Duration.ZERO;
    @Nonnull
    private final Map<String, String> extData = new LinkedHashMap<String, String>();

    public static <PayloadBuilderT> EnqueueParams<PayloadBuilderT> create(@Nonnull PayloadBuilderT payload) {
        Objects.requireNonNull(payload);
        return new EnqueueParams<PayloadBuilderT>().withPayload(payload);
    }

    @Nonnull
    public EnqueueParams<PayloadT> withPayload(@Nullable PayloadT payload) {
        this.payload = payload;
        return this;
    }

    @Nonnull
    public EnqueueParams<PayloadT> withExecutionDelay(@Nonnull Duration executionDelay) {
        this.executionDelay = Objects.requireNonNull(executionDelay);
        return this;
    }

    @Nonnull
    public EnqueueParams<PayloadT> withExtData(@Nonnull String columnName, @Nullable String value) {
        this.extData.put(Objects.requireNonNull(columnName), value);
        return this;
    }

    @Nonnull
    public EnqueueParams<PayloadT> withExtData(@Nonnull Map<String, String> extData) {
        Objects.requireNonNull(extData);
        this.extData.putAll(extData);
        return this;
    }

    @Nullable
    public PayloadT getPayload() {
        return this.payload;
    }

    @Nonnull
    public Duration getExecutionDelay() {
        return this.executionDelay;
    }

    @Nonnull
    public Map<String, String> getExtData() {
        return Collections.unmodifiableMap(this.extData);
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EnqueueParams that = (EnqueueParams)obj;
        return Objects.equals(this.payload, that.payload) && Objects.equals(this.executionDelay, that.executionDelay) && Objects.equals(this.extData, that.extData);
    }

    public int hashCode() {
        return Objects.hash(this.payload, this.executionDelay, this.extData);
    }

    public String toString() {
        return "{executionDelay=" + this.executionDelay + (this.payload != null ? ",payload=" + this.payload : "") + '}';
    }
}

