/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.api;

import java.util.Objects;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.config.QueueShardId;

public class EnqueueResult {
    @Nonnull
    private final QueueShardId shardId;
    @Nonnull
    private final Long enqueueId;

    public EnqueueResult(@Nonnull QueueShardId shardId, @Nonnull Long enqueueId) {
        this.shardId = Objects.requireNonNull(shardId);
        this.enqueueId = Objects.requireNonNull(enqueueId);
    }

    @Nonnull
    public QueueShardId getShardId() {
        return this.shardId;
    }

    @Nonnull
    public Long getEnqueueId() {
        return this.enqueueId;
    }

    public String toString() {
        return "EnqueueResult{shardId=" + this.shardId + ", enqueueId=" + this.enqueueId + '}';
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        EnqueueResult that = (EnqueueResult)obj;
        return this.shardId.equals(that.shardId) && this.enqueueId.equals(that.enqueueId);
    }

    public int hashCode() {
        return Objects.hash(this.shardId, this.enqueueId);
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private QueueShardId shardId;
        private Long enqueueId;

        private Builder() {
        }

        public Builder withShardId(@Nonnull QueueShardId shardId) {
            this.shardId = Objects.requireNonNull(shardId, "shardId must not be null");
            return this;
        }

        public Builder withEnqueueId(@Nonnull Long enqueueId) {
            this.enqueueId = Objects.requireNonNull(enqueueId, "enqueueId must not be null");
            return this;
        }

        public EnqueueResult build() {
            return new EnqueueResult(this.shardId, this.enqueueId);
        }
    }
}

