/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.api;

import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ru.yoomoney.tech.dbqueue.config.QueueShardId;

public final class Task<PayloadT> {
    @Nonnull
    private final QueueShardId shardId;
    @Nullable
    private final PayloadT payload;
    private final long attemptsCount;
    private final long reenqueueAttemptsCount;
    private final long totalAttemptsCount;
    @Nonnull
    private final ZonedDateTime createdAt;
    @Nonnull
    private final Map<String, String> extData;

    private Task(@Nonnull QueueShardId shardId, @Nullable PayloadT payload, long attemptsCount, long reenqueueAttemptsCount, long totalAttemptsCount, @Nonnull ZonedDateTime createdAt, @Nonnull Map<String, String> extData) {
        this.shardId = Objects.requireNonNull(shardId, "shardId");
        this.payload = payload;
        this.attemptsCount = attemptsCount;
        this.reenqueueAttemptsCount = reenqueueAttemptsCount;
        this.totalAttemptsCount = totalAttemptsCount;
        this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
        this.extData = Objects.requireNonNull(extData, "extData");
    }

    @Nonnull
    public Optional<PayloadT> getPayload() {
        return Optional.ofNullable(this.payload);
    }

    @Nonnull
    public PayloadT getPayloadOrThrow() {
        if (this.payload == null) {
            throw new IllegalArgumentException("payload is absent");
        }
        return this.payload;
    }

    public long getAttemptsCount() {
        return this.attemptsCount;
    }

    public long getReenqueueAttemptsCount() {
        return this.reenqueueAttemptsCount;
    }

    public long getTotalAttemptsCount() {
        return this.totalAttemptsCount;
    }

    @Nonnull
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nonnull
    public QueueShardId getShardId() {
        return this.shardId;
    }

    @Nonnull
    public Map<String, String> getExtData() {
        return this.extData;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        Task task = (Task)obj;
        return this.attemptsCount == task.attemptsCount && this.reenqueueAttemptsCount == task.reenqueueAttemptsCount && this.totalAttemptsCount == task.totalAttemptsCount && Objects.equals(this.shardId, task.shardId) && Objects.equals(this.payload, task.payload) && Objects.equals(this.createdAt, task.createdAt) && Objects.equals(this.extData, task.extData);
    }

    public int hashCode() {
        return Objects.hash(this.shardId, this.payload, this.attemptsCount, this.reenqueueAttemptsCount, this.totalAttemptsCount, this.createdAt, this.extData);
    }

    public String toString() {
        return "{shardId=" + this.shardId + ", attemptsCount=" + this.attemptsCount + ", reenqueueAttemptsCount=" + this.reenqueueAttemptsCount + ", totalAttemptsCount=" + this.totalAttemptsCount + ", createdAt=" + this.createdAt + ", payload=" + this.payload + '}';
    }

    public static <PayloadBuilderT> Builder<PayloadBuilderT> builder(@Nonnull QueueShardId shardId) {
        return new Builder(shardId);
    }

    public static class Builder<PayloadBuilderT> {
        @Nonnull
        private final QueueShardId shardId;
        @Nonnull
        private ZonedDateTime createdAt = ZonedDateTime.now();
        private PayloadBuilderT payload;
        private long attemptsCount;
        private long reenqueueAttemptsCount;
        private long totalAttemptsCount;
        @Nonnull
        private Map<String, String> extData = new LinkedHashMap<String, String>();

        private Builder(@Nonnull QueueShardId shardId) {
            this.shardId = Objects.requireNonNull(shardId, "shardId");
        }

        public Builder<PayloadBuilderT> withCreatedAt(@Nonnull ZonedDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            return this;
        }

        public Builder<PayloadBuilderT> withPayload(PayloadBuilderT payload) {
            this.payload = payload;
            return this;
        }

        public Builder<PayloadBuilderT> withAttemptsCount(long attemptsCount) {
            this.attemptsCount = attemptsCount;
            return this;
        }

        public Builder<PayloadBuilderT> withReenqueueAttemptsCount(long reenqueueAttemptsCount) {
            this.reenqueueAttemptsCount = reenqueueAttemptsCount;
            return this;
        }

        public Builder<PayloadBuilderT> withTotalAttemptsCount(long totalAttemptsCount) {
            this.totalAttemptsCount = totalAttemptsCount;
            return this;
        }

        public Builder<PayloadBuilderT> withExtData(@Nonnull Map<String, String> extData) {
            this.extData = Objects.requireNonNull(extData);
            return this;
        }

        public Task<PayloadBuilderT> build() {
            return new Task(this.shardId, this.payload, this.attemptsCount, this.reenqueueAttemptsCount, this.totalAttemptsCount, this.createdAt, this.extData);
        }
    }
}

