/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.api;

import java.time.Duration;
import java.util.Objects;
import java.util.Optional;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TaskExecutionResult {
    private static final TaskExecutionResult FINISH = new TaskExecutionResult(Type.FINISH);
    private static final TaskExecutionResult FAIL = new TaskExecutionResult(Type.FAIL);
    private static final TaskExecutionResult REENQUEUE_WITHOUT_DELAY = new TaskExecutionResult(Type.REENQUEUE);
    @Nonnull
    private final Type actionType;
    @Nullable
    private final Duration executionDelay;

    private TaskExecutionResult(@Nonnull Type actionType, @Nullable Duration executionDelay) {
        this.actionType = Objects.requireNonNull(actionType);
        this.executionDelay = executionDelay;
    }

    private TaskExecutionResult(@Nonnull Type actionType) {
        this(actionType, null);
    }

    @Nonnull
    public Type getActionType() {
        return this.actionType;
    }

    @Nonnull
    public Optional<Duration> getExecutionDelay() {
        return Optional.ofNullable(this.executionDelay);
    }

    @Nonnull
    public Duration getExecutionDelayOrThrow() {
        if (this.executionDelay == null) {
            throw new IllegalArgumentException("executionDelay is absent");
        }
        return this.executionDelay;
    }

    @Nonnull
    public static TaskExecutionResult reenqueue(@Nonnull Duration delay) {
        Objects.requireNonNull(delay);
        return new TaskExecutionResult(Type.REENQUEUE, delay);
    }

    @Nonnull
    public static TaskExecutionResult reenqueue() {
        return REENQUEUE_WITHOUT_DELAY;
    }

    @Nonnull
    public static TaskExecutionResult fail() {
        return FAIL;
    }

    @Nonnull
    public static TaskExecutionResult finish() {
        return FINISH;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TaskExecutionResult that = (TaskExecutionResult)obj;
        return this.actionType == that.actionType && Objects.equals(this.executionDelay, that.executionDelay);
    }

    public int hashCode() {
        return Objects.hash(new Object[]{this.actionType, this.executionDelay});
    }

    public String toString() {
        return "{actionType=" + (Object)((Object)this.actionType) + (this.executionDelay == null ? "" : ", executionDelay=" + this.executionDelay) + '}';
    }

    public static enum Type {
        REENQUEUE,
        FINISH,
        FAIL;

    }
}

