/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.api;

import java.time.ZonedDateTime;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;

public final class TaskRecord {
    private final long id;
    @Nullable
    private final String payload;
    private final long attemptsCount;
    private final long reenqueueAttemptsCount;
    private final long totalAttemptsCount;
    @Nonnull
    private final ZonedDateTime createdAt;
    @Nonnull
    private final ZonedDateTime nextProcessAt;
    @Nonnull
    private final Map<String, String> extData;

    private TaskRecord(long id, @Nullable String payload, long attemptsCount, long reenqueueAttemptsCount, long totalAttemptsCount, @Nonnull ZonedDateTime createdAt, @Nonnull ZonedDateTime nextProcessAt, @Nonnull Map<String, String> extData) {
        this.id = id;
        this.payload = payload;
        this.attemptsCount = attemptsCount;
        this.reenqueueAttemptsCount = reenqueueAttemptsCount;
        this.totalAttemptsCount = totalAttemptsCount;
        this.createdAt = Objects.requireNonNull(createdAt);
        this.nextProcessAt = Objects.requireNonNull(nextProcessAt);
        this.extData = Objects.requireNonNull(extData);
    }

    public long getId() {
        return this.id;
    }

    @Nullable
    public String getPayload() {
        return this.payload;
    }

    public long getAttemptsCount() {
        return this.attemptsCount;
    }

    public long getReenqueueAttemptsCount() {
        return this.reenqueueAttemptsCount;
    }

    public long getTotalAttemptsCount() {
        return this.totalAttemptsCount;
    }

    @Nonnull
    public ZonedDateTime getCreatedAt() {
        return this.createdAt;
    }

    @Nonnull
    public ZonedDateTime getNextProcessAt() {
        return this.nextProcessAt;
    }

    @Nonnull
    public Map<String, String> getExtData() {
        return this.extData;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null || this.getClass() != obj.getClass()) {
            return false;
        }
        TaskRecord that = (TaskRecord)obj;
        return this.id == that.id && this.attemptsCount == that.attemptsCount && this.reenqueueAttemptsCount == that.reenqueueAttemptsCount && this.totalAttemptsCount == that.totalAttemptsCount && Objects.equals(this.payload, that.payload) && Objects.equals(this.createdAt, that.createdAt) && Objects.equals(this.nextProcessAt, that.nextProcessAt) && Objects.equals(this.extData, that.extData);
    }

    public int hashCode() {
        return Objects.hash(this.id, this.payload, this.attemptsCount, this.reenqueueAttemptsCount, this.totalAttemptsCount, this.createdAt, this.nextProcessAt, this.extData);
    }

    public String toString() {
        return "{id=" + this.id + ", attemptsCount=" + this.attemptsCount + ", reenqueueAttemptsCount=" + this.reenqueueAttemptsCount + ", totalAttemptsCount=" + this.totalAttemptsCount + ", createdAt=" + this.createdAt + ", nextProcessAt=" + this.nextProcessAt + '}';
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private long id;
        @Nullable
        private String payload;
        private long attemptsCount;
        private long reenqueueAttemptsCount;
        private long totalAttemptsCount;
        @Nonnull
        private ZonedDateTime createdAt = ZonedDateTime.now();
        @Nonnull
        private ZonedDateTime nextProcessAt = ZonedDateTime.now();
        @Nonnull
        private Map<String, String> extData = new LinkedHashMap<String, String>();

        private Builder() {
        }

        public Builder withCreatedAt(@Nonnull ZonedDateTime createdAt) {
            this.createdAt = Objects.requireNonNull(createdAt, "createdAt");
            return this;
        }

        public Builder withNextProcessAt(@Nonnull ZonedDateTime nextProcessAt) {
            this.nextProcessAt = Objects.requireNonNull(nextProcessAt, "nextProcessAt");
            return this;
        }

        public Builder withId(long id) {
            this.id = id;
            return this;
        }

        public Builder withPayload(String payload) {
            this.payload = payload;
            return this;
        }

        public Builder withAttemptsCount(long attemptsCount) {
            this.attemptsCount = attemptsCount;
            return this;
        }

        public Builder withReenqueueAttemptsCount(long reenqueueAttemptsCount) {
            this.reenqueueAttemptsCount = reenqueueAttemptsCount;
            return this;
        }

        public Builder withTotalAttemptsCount(long totalAttemptsCount) {
            this.totalAttemptsCount = totalAttemptsCount;
            return this;
        }

        public Builder withExtData(@Nonnull Map<String, String> extData) {
            this.extData = Objects.requireNonNull(extData);
            return this;
        }

        public TaskRecord build() {
            return new TaskRecord(this.id, this.payload, this.attemptsCount, this.reenqueueAttemptsCount, this.totalAttemptsCount, this.createdAt, this.nextProcessAt, this.extData);
        }
    }
}

