/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.api.impl;

import java.time.Clock;
import java.util.Objects;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yoomoney.tech.dbqueue.api.EnqueueParams;
import ru.yoomoney.tech.dbqueue.api.EnqueueResult;
import ru.yoomoney.tech.dbqueue.api.QueueProducer;
import ru.yoomoney.tech.dbqueue.api.TaskPayloadTransformer;
import ru.yoomoney.tech.dbqueue.settings.QueueId;

public class MonitoringQueueProducer<PayloadT>
implements QueueProducer<PayloadT> {
    private static final Logger log = LoggerFactory.getLogger(MonitoringQueueProducer.class);
    @Nonnull
    private final QueueProducer<PayloadT> queueProducer;
    @Nonnull
    private final QueueId queueId;
    @Nonnull
    private final BiConsumer<EnqueueResult, Long> monitoringCallback;
    @Nonnull
    private final Clock clock;

    MonitoringQueueProducer(@Nonnull QueueProducer<PayloadT> queueProducer, @Nonnull QueueId queueId, @Nonnull BiConsumer<EnqueueResult, Long> monitoringCallback, @Nonnull Clock clock) {
        this.queueProducer = Objects.requireNonNull(queueProducer);
        this.queueId = Objects.requireNonNull(queueId);
        this.monitoringCallback = Objects.requireNonNull(monitoringCallback);
        this.clock = Objects.requireNonNull(clock);
    }

    public MonitoringQueueProducer(@Nonnull QueueProducer<PayloadT> queueProducer, @Nonnull QueueId queueId, @Nonnull BiConsumer<EnqueueResult, Long> monitoringCallback) {
        this(queueProducer, queueId, monitoringCallback, Clock.systemDefaultZone());
    }

    public MonitoringQueueProducer(@Nonnull QueueProducer<PayloadT> queueProducer, @Nonnull QueueId queueId) {
        this(queueProducer, queueId, (enqueueResult, id) -> {});
    }

    @Override
    public EnqueueResult enqueue(@Nonnull EnqueueParams<PayloadT> enqueueParams) {
        log.info("enqueuing task: queue={}, delay={}", (Object)this.queueId, (Object)enqueueParams.getExecutionDelay());
        long startTime = this.clock.millis();
        EnqueueResult enqueueResult = this.queueProducer.enqueue(enqueueParams);
        log.info("task enqueued: id={}, queueShardId={}", (Object)enqueueResult.getEnqueueId(), (Object)enqueueResult.getShardId());
        long elapsedTime = this.clock.millis() - startTime;
        this.monitoringCallback.accept(enqueueResult, elapsedTime);
        return enqueueResult;
    }

    @Override
    @Nonnull
    public TaskPayloadTransformer<PayloadT> getPayloadTransformer() {
        return this.queueProducer.getPayloadTransformer();
    }
}

