/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.api.impl;

import java.util.Objects;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.api.EnqueueParams;
import ru.yoomoney.tech.dbqueue.api.EnqueueResult;
import ru.yoomoney.tech.dbqueue.api.QueueProducer;
import ru.yoomoney.tech.dbqueue.api.QueueShardRouter;
import ru.yoomoney.tech.dbqueue.api.TaskPayloadTransformer;
import ru.yoomoney.tech.dbqueue.config.DatabaseAccessLayer;
import ru.yoomoney.tech.dbqueue.config.QueueShard;
import ru.yoomoney.tech.dbqueue.settings.QueueConfig;

public class ShardingQueueProducer<PayloadTaskT, DatabaseAccessLayerT extends DatabaseAccessLayer>
implements QueueProducer<PayloadTaskT> {
    @Nonnull
    private final QueueShardRouter<PayloadTaskT, DatabaseAccessLayerT> queueShardRouter;
    @Nonnull
    private final TaskPayloadTransformer<PayloadTaskT> payloadTransformer;
    @Nonnull
    private final QueueConfig queueConfig;

    public ShardingQueueProducer(@Nonnull QueueConfig queueConfig, @Nonnull TaskPayloadTransformer<PayloadTaskT> payloadTransformer, @Nonnull QueueShardRouter<PayloadTaskT, DatabaseAccessLayerT> queueShardRouter) {
        this.queueShardRouter = Objects.requireNonNull(queueShardRouter);
        this.payloadTransformer = Objects.requireNonNull(payloadTransformer);
        this.queueConfig = Objects.requireNonNull(queueConfig);
    }

    @Override
    public EnqueueResult enqueue(@Nonnull EnqueueParams<PayloadTaskT> enqueueParams) {
        QueueShard<DatabaseAccessLayerT> queueShard = this.queueShardRouter.resolveShard(enqueueParams);
        EnqueueParams<String> rawEnqueueParams = new EnqueueParams<String>().withPayload(this.payloadTransformer.fromObject(enqueueParams.getPayload())).withExecutionDelay(enqueueParams.getExecutionDelay()).withExtData(enqueueParams.getExtData());
        Long enqueueId = queueShard.getDatabaseAccessLayer().transact(() -> queueShard.getDatabaseAccessLayer().getQueueDao().enqueue(this.queueConfig.getLocation(), rawEnqueueParams));
        return EnqueueResult.builder().withShardId(queueShard.getShardId()).withEnqueueId(enqueueId).build();
    }

    @Override
    @Nonnull
    public TaskPayloadTransformer<PayloadTaskT> getPayloadTransformer() {
        return this.payloadTransformer;
    }
}

