/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.config;

import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.regex.Pattern;
import java.util.stream.Collectors;
import javax.annotation.Nonnull;

public class QueueTableSchema {
    private static final Pattern DISALLOWED_CHARS = Pattern.compile("[^a-zA-Z0-9_]*");
    @Nonnull
    private final String idField;
    @Nonnull
    private final String queueNameField;
    @Nonnull
    private final String payloadField;
    @Nonnull
    private final String attemptField;
    @Nonnull
    private final String reenqueueAttemptField;
    @Nonnull
    private final String totalAttemptField;
    @Nonnull
    private final String createdAtField;
    @Nonnull
    private final String nextProcessAtField;
    @Nonnull
    private final List<String> extFields;

    private QueueTableSchema(@Nonnull String idField, @Nonnull String queueNameField, @Nonnull String payloadField, @Nonnull String attemptField, @Nonnull String reenqueueAttemptField, @Nonnull String totalAttemptField, @Nonnull String createdAtField, @Nonnull String nextProcessAtField, @Nonnull List<String> extFields) {
        this.idField = QueueTableSchema.removeSpecialChars(Objects.requireNonNull(idField));
        this.queueNameField = QueueTableSchema.removeSpecialChars(Objects.requireNonNull(queueNameField));
        this.payloadField = QueueTableSchema.removeSpecialChars(Objects.requireNonNull(payloadField));
        this.attemptField = QueueTableSchema.removeSpecialChars(Objects.requireNonNull(attemptField));
        this.reenqueueAttemptField = QueueTableSchema.removeSpecialChars(Objects.requireNonNull(reenqueueAttemptField));
        this.totalAttemptField = QueueTableSchema.removeSpecialChars(Objects.requireNonNull(totalAttemptField));
        this.createdAtField = QueueTableSchema.removeSpecialChars(Objects.requireNonNull(createdAtField));
        this.nextProcessAtField = QueueTableSchema.removeSpecialChars(Objects.requireNonNull(nextProcessAtField));
        this.extFields = Objects.requireNonNull(extFields).stream().map(QueueTableSchema::removeSpecialChars).collect(Collectors.toList());
    }

    private static String removeSpecialChars(@Nonnull String value) {
        return DISALLOWED_CHARS.matcher(value).replaceAll("");
    }

    @Nonnull
    public String getPayloadField() {
        return this.payloadField;
    }

    @Nonnull
    public String getAttemptField() {
        return this.attemptField;
    }

    @Nonnull
    public String getReenqueueAttemptField() {
        return this.reenqueueAttemptField;
    }

    @Nonnull
    public String getTotalAttemptField() {
        return this.totalAttemptField;
    }

    @Nonnull
    public String getCreatedAtField() {
        return this.createdAtField;
    }

    @Nonnull
    public String getNextProcessAtField() {
        return this.nextProcessAtField;
    }

    @Nonnull
    public String getQueueNameField() {
        return this.queueNameField;
    }

    @Nonnull
    public String getIdField() {
        return this.idField;
    }

    @Nonnull
    public List<String> getExtFields() {
        return this.extFields;
    }

    public static Builder builder() {
        return new Builder();
    }

    public static class Builder {
        private String idField = "id";
        private String queueNameField = "queue_name";
        private String payloadField = "payload";
        private String attemptField = "attempt";
        private String reenqueueAttemptField = "reenqueue_attempt";
        private String totalAttemptField = "total_attempt";
        private String createdAtField = "created_at";
        private String nextProcessAtField = "next_process_at";
        private List<String> extFields = new ArrayList<String>();

        private Builder() {
        }

        public Builder withIdField(String idField) {
            this.idField = idField;
            return this;
        }

        public Builder withQueueNameField(String queueNameField) {
            this.queueNameField = queueNameField;
            return this;
        }

        public Builder withPayloadField(String payloadField) {
            this.payloadField = payloadField;
            return this;
        }

        public Builder withAttemptField(String attemptField) {
            this.attemptField = attemptField;
            return this;
        }

        public Builder withReenqueueAttemptField(String reenqueueAttemptField) {
            this.reenqueueAttemptField = reenqueueAttemptField;
            return this;
        }

        public Builder withTotalAttemptField(String totalAttemptField) {
            this.totalAttemptField = totalAttemptField;
            return this;
        }

        public Builder withCreatedAtField(String createdAtField) {
            this.createdAtField = createdAtField;
            return this;
        }

        public Builder withNextProcessAtField(String nextProcessAtField) {
            this.nextProcessAtField = nextProcessAtField;
            return this;
        }

        public Builder withExtFields(List<String> extFields) {
            this.extFields = extFields;
            return this;
        }

        public QueueTableSchema build() {
            return new QueueTableSchema(this.idField, this.queueNameField, this.payloadField, this.attemptField, this.reenqueueAttemptField, this.totalAttemptField, this.createdAtField, this.nextProcessAtField, this.extFields);
        }
    }
}

