/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.config.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ru.yoomoney.tech.dbqueue.api.TaskExecutionResult;
import ru.yoomoney.tech.dbqueue.api.TaskRecord;
import ru.yoomoney.tech.dbqueue.config.QueueShardId;
import ru.yoomoney.tech.dbqueue.config.TaskLifecycleListener;
import ru.yoomoney.tech.dbqueue.settings.QueueLocation;

public class CompositeTaskLifecycleListener
implements TaskLifecycleListener {
    @Nonnull
    private final List<TaskLifecycleListener> listeners;
    @Nonnull
    private final List<TaskLifecycleListener> reverseListeners;

    public CompositeTaskLifecycleListener(@Nonnull List<TaskLifecycleListener> listeners) {
        this.listeners = Objects.requireNonNull(listeners, "listeners must not be null");
        this.reverseListeners = new ArrayList<TaskLifecycleListener>(listeners);
        Collections.reverse(this.reverseListeners);
    }

    @Override
    public void picked(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location, @Nonnull TaskRecord taskRecord, long pickTaskTime) {
        this.listeners.forEach(l -> l.picked(shardId, location, taskRecord, pickTaskTime));
    }

    @Override
    public void started(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location, @Nonnull TaskRecord taskRecord) {
        this.listeners.forEach(l -> l.started(shardId, location, taskRecord));
    }

    @Override
    public void executed(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location, @Nonnull TaskRecord taskRecord, @Nonnull TaskExecutionResult executionResult, long processTaskTime) {
        this.reverseListeners.forEach(l -> l.executed(shardId, location, taskRecord, executionResult, processTaskTime));
    }

    @Override
    public void finished(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location, @Nonnull TaskRecord taskRecord) {
        this.reverseListeners.forEach(l -> l.finished(shardId, location, taskRecord));
    }

    @Override
    public void crashed(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location, @Nonnull TaskRecord taskRecord, @Nullable Exception exc) {
        this.reverseListeners.forEach(l -> l.crashed(shardId, location, taskRecord, exc));
    }
}

