/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.config.impl;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ru.yoomoney.tech.dbqueue.config.QueueShardId;
import ru.yoomoney.tech.dbqueue.config.ThreadLifecycleListener;
import ru.yoomoney.tech.dbqueue.settings.QueueLocation;

public class CompositeThreadLifecycleListener
implements ThreadLifecycleListener {
    @Nonnull
    private final List<ThreadLifecycleListener> listeners;
    @Nonnull
    private final List<ThreadLifecycleListener> reverseListeners;

    public CompositeThreadLifecycleListener(@Nonnull List<ThreadLifecycleListener> listeners) {
        this.listeners = Objects.requireNonNull(listeners, "listeners must not be null");
        this.reverseListeners = new ArrayList<ThreadLifecycleListener>(listeners);
        Collections.reverse(this.reverseListeners);
    }

    @Override
    public void started(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location) {
        this.listeners.forEach(l -> l.started(shardId, location));
    }

    @Override
    public void executed(QueueShardId shardId, QueueLocation location, boolean taskProcessed, long threadBusyTime) {
        this.reverseListeners.forEach(l -> l.executed(shardId, location, taskProcessed, threadBusyTime));
    }

    @Override
    public void finished(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location) {
        this.reverseListeners.forEach(l -> l.finished(shardId, location));
    }

    @Override
    public void crashed(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location, @Nullable Throwable exc) {
        this.reverseListeners.forEach(l -> l.crashed(shardId, location, exc));
    }
}

