/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.config.impl;

import java.time.Clock;
import java.time.Duration;
import java.time.ZonedDateTime;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import ru.yoomoney.tech.dbqueue.api.TaskExecutionResult;
import ru.yoomoney.tech.dbqueue.api.TaskRecord;
import ru.yoomoney.tech.dbqueue.config.QueueShardId;
import ru.yoomoney.tech.dbqueue.config.TaskLifecycleListener;
import ru.yoomoney.tech.dbqueue.settings.QueueLocation;

public class LoggingTaskLifecycleListener
implements TaskLifecycleListener {
    private static final Logger log = LoggerFactory.getLogger(LoggingTaskLifecycleListener.class);
    private final Clock clock;

    public LoggingTaskLifecycleListener() {
        this(Clock.systemDefaultZone());
    }

    LoggingTaskLifecycleListener(@Nonnull Clock clock) {
        this.clock = Objects.requireNonNull(clock);
    }

    @Override
    public void picked(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location, @Nonnull TaskRecord taskRecord, long pickTaskTime) {
    }

    @Override
    public void started(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location, @Nonnull TaskRecord taskRecord) {
        log.info("consuming task: id={}, attempt={}", (Object)taskRecord.getId(), (Object)taskRecord.getAttemptsCount());
    }

    @Override
    public void executed(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location, @Nonnull TaskRecord taskRecord, @Nonnull TaskExecutionResult executionResult, long processTaskTime) {
        switch (executionResult.getActionType()) {
            case FINISH: {
                Duration inQueueTime = Duration.between(taskRecord.getCreatedAt(), ZonedDateTime.now(this.clock));
                log.info("task finished: id={}, in-queue={}, time={}", new Object[]{taskRecord.getId(), inQueueTime, processTaskTime});
                break;
            }
            case REENQUEUE: {
                log.info("task reenqueued: id={}, delay={}, time={}", new Object[]{taskRecord.getId(), executionResult.getExecutionDelay().orElse(null), processTaskTime});
                break;
            }
            case FAIL: {
                log.info("task failed: id={}, time={}", (Object)taskRecord.getId(), (Object)processTaskTime);
                break;
            }
            default: {
                log.warn("unknown action type: type={}", (Object)executionResult.getActionType());
            }
        }
    }

    @Override
    public void finished(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location, @Nonnull TaskRecord taskRecord) {
    }

    @Override
    public void crashed(@Nonnull QueueShardId shardId, @Nonnull QueueLocation location, @Nonnull TaskRecord taskRecord, @Nullable Exception exc) {
        log.error("error while processing task: task={}", (Object)taskRecord, (Object)exc);
    }
}

