/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.internal.processing;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.time.Duration;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public interface QueueLoop {
    public void doRun(Runnable var1);

    public void doContinue();

    public void doWait(Duration var1, WaitInterrupt var2);

    public boolean isPaused();

    public void pause();

    public void unpause();

    public static enum WaitInterrupt {
        ALLOW,
        DENY;

    }

    @SuppressFBWarnings(value={"LO_SUSPECT_LOG_CLASS"})
    public static class WakeupQueueLoop
    implements QueueLoop {
        private static final Logger log = LoggerFactory.getLogger(QueueLoop.class);
        private final Object monitor = new Object();
        private volatile boolean isWakedUp = false;
        private volatile boolean isPaused = true;

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doRun(Runnable runnable) {
            while (!Thread.currentThread().isInterrupted()) {
                try {
                    Object object = this.monitor;
                    synchronized (object) {
                        while (this.isPaused) {
                            this.monitor.wait();
                        }
                    }
                    runnable.run();
                }
                catch (InterruptedException ignored) {
                    log.info("sleep interrupted: threadName={}", (Object)Thread.currentThread().getName());
                    Thread.currentThread().interrupt();
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doContinue() {
            Object object = this.monitor;
            synchronized (object) {
                this.isWakedUp = true;
                this.monitor.notify();
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void doWait(Duration timeout, WaitInterrupt waitInterrupt) {
            try {
                Object object = this.monitor;
                synchronized (object) {
                    long plannedWakeupTime = System.currentTimeMillis() + timeout.toMillis();
                    long timeToSleep = plannedWakeupTime - System.currentTimeMillis();
                    while (timeToSleep > 1L) {
                        if (!this.isWakedUp) {
                            this.monitor.wait(timeToSleep);
                        }
                        if (this.isWakedUp && waitInterrupt == WaitInterrupt.ALLOW) break;
                        if (this.isWakedUp && waitInterrupt == WaitInterrupt.DENY) {
                            this.isWakedUp = false;
                        }
                        timeToSleep = plannedWakeupTime - System.currentTimeMillis();
                    }
                    this.isWakedUp = false;
                }
            }
            catch (InterruptedException ignored) {
                log.info("sleep interrupted: threadName={}", (Object)Thread.currentThread().getName());
                Thread.currentThread().interrupt();
            }
        }

        @Override
        public boolean isPaused() {
            return this.isPaused;
        }

        @Override
        public void pause() {
            this.isPaused = true;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void unpause() {
            Object object = this.monitor;
            synchronized (object) {
                this.isPaused = false;
                this.monitor.notifyAll();
            }
        }
    }
}

