/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.internal.processing;

import java.util.Objects;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.api.QueueConsumer;
import ru.yoomoney.tech.dbqueue.config.QueueShardId;
import ru.yoomoney.tech.dbqueue.config.ThreadLifecycleListener;
import ru.yoomoney.tech.dbqueue.internal.processing.MillisTimeProvider;
import ru.yoomoney.tech.dbqueue.internal.processing.QueueLoop;
import ru.yoomoney.tech.dbqueue.internal.processing.QueueProcessingStatus;
import ru.yoomoney.tech.dbqueue.internal.runner.QueueRunner;
import ru.yoomoney.tech.dbqueue.settings.PollSettings;

public class QueueTaskPoller {
    @Nonnull
    private final ThreadLifecycleListener threadLifecycleListener;
    @Nonnull
    private final MillisTimeProvider millisTimeProvider;

    public QueueTaskPoller(@Nonnull ThreadLifecycleListener threadLifecycleListener, @Nonnull MillisTimeProvider millisTimeProvider) {
        this.threadLifecycleListener = Objects.requireNonNull(threadLifecycleListener);
        this.millisTimeProvider = Objects.requireNonNull(millisTimeProvider);
    }

    public void start(@Nonnull QueueLoop queueLoop, @Nonnull QueueShardId shardId, @Nonnull QueueConsumer queueConsumer, @Nonnull QueueRunner queueRunner) {
        Objects.requireNonNull(shardId);
        Objects.requireNonNull(queueConsumer);
        Objects.requireNonNull(queueRunner);
        Objects.requireNonNull(queueLoop);
        queueLoop.doRun(() -> {
            PollSettings pollSettings = queueConsumer.getQueueConfig().getSettings().getPollSettings();
            try {
                long startTime = this.millisTimeProvider.getMillis();
                this.threadLifecycleListener.started(shardId, queueConsumer.getQueueConfig().getLocation());
                QueueProcessingStatus queueProcessingStatus = queueRunner.runQueue(queueConsumer);
                this.threadLifecycleListener.executed(shardId, queueConsumer.getQueueConfig().getLocation(), queueProcessingStatus != QueueProcessingStatus.SKIPPED, this.millisTimeProvider.getMillis() - startTime);
                switch (queueProcessingStatus) {
                    case SKIPPED: {
                        queueLoop.doWait(pollSettings.getNoTaskTimeout(), QueueLoop.WaitInterrupt.ALLOW);
                        return;
                    }
                    case PROCESSED: {
                        queueLoop.doWait(pollSettings.getBetweenTaskTimeout(), QueueLoop.WaitInterrupt.DENY);
                        return;
                    }
                }
                try {
                    throw new IllegalStateException("unknown task loop result" + (Object)((Object)queueProcessingStatus));
                }
                catch (Throwable e) {
                    this.threadLifecycleListener.crashed(shardId, queueConsumer.getQueueConfig().getLocation(), e);
                    queueLoop.doWait(pollSettings.getFatalCrashTimeout(), QueueLoop.WaitInterrupt.DENY);
                }
            }
            finally {
                this.threadLifecycleListener.finished(shardId, queueConsumer.getQueueConfig().getLocation());
            }
        });
    }
}

