/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.internal.processing;

import java.time.Duration;
import java.util.Collections;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.api.TaskRecord;
import ru.yoomoney.tech.dbqueue.settings.ReenqueueSettings;

public interface ReenqueueRetryStrategy {
    @Nonnull
    public Duration calculateDelay(@Nonnull TaskRecord var1);

    public static class GeometricReenqueueRetryStrategy
    implements ReenqueueRetryStrategy {
        @Nonnull
        private final Duration initialDelay;
        private final long ratio;

        GeometricReenqueueRetryStrategy(@Nonnull Duration initialDelay, long ratio) {
            this.initialDelay = Objects.requireNonNull(initialDelay, "initialDelay");
            this.ratio = ratio;
        }

        @Override
        @Nonnull
        public Duration calculateDelay(@Nonnull TaskRecord taskRecord) {
            return this.initialDelay.multipliedBy((long)Math.pow(this.ratio, taskRecord.getReenqueueAttemptsCount()));
        }
    }

    public static class ArithmeticReenqueueRetryStrategy
    implements ReenqueueRetryStrategy {
        @Nonnull
        private final Duration initialDelay;
        @Nonnull
        private final Duration step;

        ArithmeticReenqueueRetryStrategy(@Nonnull Duration initialDelay, @Nonnull Duration step) {
            this.initialDelay = Objects.requireNonNull(initialDelay, "initialDelay");
            this.step = Objects.requireNonNull(step, "step");
        }

        @Override
        @Nonnull
        public Duration calculateDelay(@Nonnull TaskRecord taskRecord) {
            return this.initialDelay.plus(this.step.multipliedBy(taskRecord.getReenqueueAttemptsCount()));
        }
    }

    public static class SequentialReenqueueRetryStrategy
    implements ReenqueueRetryStrategy {
        @Nonnull
        private final List<Duration> retryPlan;

        SequentialReenqueueRetryStrategy(@Nonnull List<Duration> retryPlan) {
            this.retryPlan = Collections.unmodifiableList(retryPlan);
        }

        @Override
        @Nonnull
        public Duration calculateDelay(@Nonnull TaskRecord taskRecord) {
            if (taskRecord.getReenqueueAttemptsCount() >= (long)this.retryPlan.size()) {
                return this.retryPlan.get(this.retryPlan.size() - 1);
            }
            return this.retryPlan.get((int)taskRecord.getReenqueueAttemptsCount());
        }
    }

    public static class FixedDelayReenqueueRetryStrategy
    implements ReenqueueRetryStrategy {
        @Nonnull
        private final Duration delay;

        FixedDelayReenqueueRetryStrategy(@Nonnull Duration delay) {
            this.delay = Objects.requireNonNull(delay, "delay");
        }

        @Override
        @Nonnull
        public Duration calculateDelay(@Nonnull TaskRecord taskRecord) {
            return this.delay;
        }
    }

    public static class ManualReenqueueRetryStrategy
    implements ReenqueueRetryStrategy {
        @Override
        @Nonnull
        public Duration calculateDelay(@Nonnull TaskRecord taskRecord) {
            throw new UnsupportedOperationException("re-enqueue delay must be set explicitly via 'reenqueue(Duration)' method call");
        }
    }

    public static final class Factory {
        private Factory() {
        }

        @Nonnull
        public static ReenqueueRetryStrategy create(@Nonnull ReenqueueSettings reenqueueSettings) {
            Objects.requireNonNull(reenqueueSettings, "reenqueueRetrySettings");
            switch (reenqueueSettings.getRetryType()) {
                case MANUAL: {
                    return new ManualReenqueueRetryStrategy();
                }
                case FIXED: {
                    return new FixedDelayReenqueueRetryStrategy(reenqueueSettings.getFixedDelayOrThrow());
                }
                case SEQUENTIAL: {
                    return new SequentialReenqueueRetryStrategy(reenqueueSettings.getSequentialPlanOrThrow());
                }
                case ARITHMETIC: {
                    return new ArithmeticReenqueueRetryStrategy(reenqueueSettings.getInitialDelayOrThrow(), reenqueueSettings.getArithmeticStepOrThrow());
                }
                case GEOMETRIC: {
                    return new GeometricReenqueueRetryStrategy(reenqueueSettings.getInitialDelayOrThrow(), reenqueueSettings.getGeometricRatioOrThrow());
                }
            }
            throw new IllegalArgumentException("unknown re-enqueue retry type: type=" + (Object)((Object)reenqueueSettings.getRetryType()));
        }
    }
}

