/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.internal.processing;

import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import ru.yoomoney.tech.dbqueue.api.TaskRecord;
import ru.yoomoney.tech.dbqueue.config.QueueShard;
import ru.yoomoney.tech.dbqueue.config.TaskLifecycleListener;
import ru.yoomoney.tech.dbqueue.dao.QueuePickTaskDao;
import ru.yoomoney.tech.dbqueue.internal.processing.MillisTimeProvider;
import ru.yoomoney.tech.dbqueue.settings.QueueLocation;

public class TaskPicker {
    @Nonnull
    private final QueueShard<?> queueShard;
    @Nonnull
    private final QueueLocation queueLocation;
    @Nonnull
    private final TaskLifecycleListener taskLifecycleListener;
    @Nonnull
    private final MillisTimeProvider millisTimeProvider;
    private final QueuePickTaskDao pickTaskDao;

    public TaskPicker(@Nonnull QueueShard<?> queueShard, @Nonnull QueueLocation queueLocation, @Nonnull TaskLifecycleListener taskLifecycleListener, @Nonnull MillisTimeProvider millisTimeProvider, @Nonnull QueuePickTaskDao pickTaskDao) {
        this.queueShard = Objects.requireNonNull(queueShard);
        this.queueLocation = Objects.requireNonNull(queueLocation);
        this.taskLifecycleListener = Objects.requireNonNull(taskLifecycleListener);
        this.millisTimeProvider = Objects.requireNonNull(millisTimeProvider);
        this.pickTaskDao = Objects.requireNonNull(pickTaskDao);
    }

    @Nullable
    public TaskRecord pickTask() {
        long startPickTaskTime = this.millisTimeProvider.getMillis();
        TaskRecord taskRecord = this.queueShard.getDatabaseAccessLayer().transact(this.pickTaskDao::pickTask);
        if (taskRecord == null) {
            return null;
        }
        this.taskLifecycleListener.picked(this.queueShard.getShardId(), this.queueLocation, taskRecord, this.millisTimeProvider.getMillis() - startPickTaskTime);
        return taskRecord;
    }
}

