/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.internal.processing;

import java.util.Objects;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.api.QueueConsumer;
import ru.yoomoney.tech.dbqueue.api.Task;
import ru.yoomoney.tech.dbqueue.api.TaskExecutionResult;
import ru.yoomoney.tech.dbqueue.api.TaskRecord;
import ru.yoomoney.tech.dbqueue.config.QueueShard;
import ru.yoomoney.tech.dbqueue.config.TaskLifecycleListener;
import ru.yoomoney.tech.dbqueue.internal.processing.MillisTimeProvider;
import ru.yoomoney.tech.dbqueue.internal.processing.TaskResultHandler;

public class TaskProcessor {
    @Nonnull
    private final QueueShard<?> queueShard;
    @Nonnull
    private final TaskLifecycleListener taskLifecycleListener;
    @Nonnull
    private final MillisTimeProvider millisTimeProvider;
    @Nonnull
    private final TaskResultHandler taskResultHandler;

    public TaskProcessor(@Nonnull QueueShard<?> queueShard, @Nonnull TaskLifecycleListener taskLifecycleListener, @Nonnull MillisTimeProvider millisTimeProvider, @Nonnull TaskResultHandler taskResultHandler) {
        this.queueShard = Objects.requireNonNull(queueShard);
        this.taskLifecycleListener = Objects.requireNonNull(taskLifecycleListener);
        this.millisTimeProvider = Objects.requireNonNull(millisTimeProvider);
        this.taskResultHandler = Objects.requireNonNull(taskResultHandler);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void processTask(@Nonnull QueueConsumer queueConsumer, @Nonnull TaskRecord taskRecord) {
        Objects.requireNonNull(queueConsumer);
        Objects.requireNonNull(taskRecord);
        try {
            this.taskLifecycleListener.started(this.queueShard.getShardId(), queueConsumer.getQueueConfig().getLocation(), taskRecord);
            long processTaskStarted = this.millisTimeProvider.getMillis();
            Object payload = queueConsumer.getPayloadTransformer().toObject(taskRecord.getPayload());
            Task task = Task.builder(this.queueShard.getShardId()).withCreatedAt(taskRecord.getCreatedAt()).withPayload(payload).withAttemptsCount(taskRecord.getAttemptsCount()).withReenqueueAttemptsCount(taskRecord.getReenqueueAttemptsCount()).withTotalAttemptsCount(taskRecord.getTotalAttemptsCount()).withExtData(taskRecord.getExtData()).build();
            TaskExecutionResult executionResult = queueConsumer.execute(task);
            this.taskLifecycleListener.executed(this.queueShard.getShardId(), queueConsumer.getQueueConfig().getLocation(), taskRecord, executionResult, this.millisTimeProvider.getMillis() - processTaskStarted);
            this.taskResultHandler.handleResult(taskRecord, executionResult);
        }
        catch (Exception exc) {
            this.taskLifecycleListener.crashed(this.queueShard.getShardId(), queueConsumer.getQueueConfig().getLocation(), taskRecord, exc);
        }
        finally {
            this.taskLifecycleListener.finished(this.queueShard.getShardId(), queueConsumer.getQueueConfig().getLocation(), taskRecord);
        }
    }
}

