/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.internal.processing;

import java.util.Objects;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.api.TaskExecutionResult;
import ru.yoomoney.tech.dbqueue.api.TaskRecord;
import ru.yoomoney.tech.dbqueue.config.QueueShard;
import ru.yoomoney.tech.dbqueue.internal.processing.ReenqueueRetryStrategy;
import ru.yoomoney.tech.dbqueue.settings.QueueLocation;
import ru.yoomoney.tech.dbqueue.settings.ReenqueueSettings;

public class TaskResultHandler {
    @Nonnull
    private final QueueLocation location;
    @Nonnull
    private final QueueShard<?> queueShard;
    @Nonnull
    private ReenqueueRetryStrategy reenqueueRetryStrategy;

    public TaskResultHandler(@Nonnull QueueLocation location, @Nonnull QueueShard<?> queueShard, @Nonnull ReenqueueSettings reenqueueSettings) {
        this.location = Objects.requireNonNull(location);
        this.queueShard = Objects.requireNonNull(queueShard);
        this.reenqueueRetryStrategy = ReenqueueRetryStrategy.Factory.create(reenqueueSettings);
        reenqueueSettings.registerObserver((oldValue, newValue) -> {
            this.reenqueueRetryStrategy = ReenqueueRetryStrategy.Factory.create(newValue);
        });
    }

    public void handleResult(@Nonnull TaskRecord taskRecord, @Nonnull TaskExecutionResult executionResult) {
        Objects.requireNonNull(taskRecord);
        Objects.requireNonNull(executionResult);
        switch (executionResult.getActionType()) {
            case FINISH: {
                this.queueShard.getDatabaseAccessLayer().transact(() -> this.queueShard.getDatabaseAccessLayer().getQueueDao().deleteTask(this.location, taskRecord.getId()));
                return;
            }
            case REENQUEUE: {
                this.queueShard.getDatabaseAccessLayer().transact(() -> this.queueShard.getDatabaseAccessLayer().getQueueDao().reenqueue(this.location, taskRecord.getId(), executionResult.getExecutionDelay().orElseGet(() -> this.reenqueueRetryStrategy.calculateDelay(taskRecord))));
                return;
            }
            case FAIL: {
                return;
            }
        }
        throw new IllegalStateException("unknown action type: " + (Object)((Object)executionResult.getActionType()));
    }
}

