/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.internal.processing;

import java.time.Duration;
import java.util.Objects;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.internal.processing.MillisTimeProvider;

public class TimeLimiter {
    @Nonnull
    private final MillisTimeProvider millisTimeProvider;
    private Duration remainingTimeout;
    private Duration elapsedTime = Duration.ZERO;

    public TimeLimiter(@Nonnull MillisTimeProvider millisTimeProvider, @Nonnull Duration timeout) {
        this.millisTimeProvider = Objects.requireNonNull(millisTimeProvider);
        this.remainingTimeout = Objects.requireNonNull(timeout);
    }

    public void execute(@Nonnull Consumer<Duration> consumer) {
        Objects.requireNonNull(consumer);
        if (this.remainingTimeout.equals(Duration.ZERO)) {
            return;
        }
        long startTime = this.millisTimeProvider.getMillis();
        consumer.accept(this.remainingTimeout);
        this.elapsedTime = this.elapsedTime.plus(Duration.ofMillis(this.millisTimeProvider.getMillis() - startTime));
        this.remainingTimeout = this.remainingTimeout.compareTo(this.elapsedTime) <= 0 ? Duration.ZERO : this.remainingTimeout.minus(this.elapsedTime);
    }
}

