/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.internal.runner;

import java.util.Objects;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.api.QueueConsumer;
import ru.yoomoney.tech.dbqueue.api.TaskRecord;
import ru.yoomoney.tech.dbqueue.internal.processing.QueueProcessingStatus;
import ru.yoomoney.tech.dbqueue.internal.processing.TaskPicker;
import ru.yoomoney.tech.dbqueue.internal.processing.TaskProcessor;
import ru.yoomoney.tech.dbqueue.internal.runner.QueueRunner;

public class BaseQueueRunner
implements QueueRunner {
    @Nonnull
    private final TaskPicker taskPicker;
    @Nonnull
    private final TaskProcessor taskProcessor;
    @Nonnull
    private final Executor executor;

    BaseQueueRunner(@Nonnull TaskPicker taskPicker, @Nonnull TaskProcessor taskProcessor, @Nonnull Executor executor) {
        this.taskPicker = Objects.requireNonNull(taskPicker);
        this.taskProcessor = Objects.requireNonNull(taskProcessor);
        this.executor = Objects.requireNonNull(executor);
    }

    @Override
    @Nonnull
    public QueueProcessingStatus runQueue(@Nonnull QueueConsumer queueConsumer) {
        TaskRecord taskRecord = this.taskPicker.pickTask();
        if (taskRecord == null) {
            return QueueProcessingStatus.SKIPPED;
        }
        this.executor.execute(() -> this.taskProcessor.processTask(queueConsumer, taskRecord));
        return QueueProcessingStatus.PROCESSED;
    }
}

