/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.internal.runner;

import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.Executor;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.api.QueueConsumer;
import ru.yoomoney.tech.dbqueue.config.QueueShard;
import ru.yoomoney.tech.dbqueue.config.TaskLifecycleListener;
import ru.yoomoney.tech.dbqueue.dao.QueuePickTaskDao;
import ru.yoomoney.tech.dbqueue.internal.processing.MillisTimeProvider;
import ru.yoomoney.tech.dbqueue.internal.processing.QueueProcessingStatus;
import ru.yoomoney.tech.dbqueue.internal.processing.TaskPicker;
import ru.yoomoney.tech.dbqueue.internal.processing.TaskProcessor;
import ru.yoomoney.tech.dbqueue.internal.processing.TaskResultHandler;
import ru.yoomoney.tech.dbqueue.internal.runner.QueueRunnerInExternalExecutor;
import ru.yoomoney.tech.dbqueue.internal.runner.QueueRunnerInSeparateTransactions;
import ru.yoomoney.tech.dbqueue.internal.runner.QueueRunnerInTransaction;
import ru.yoomoney.tech.dbqueue.settings.ProcessingMode;
import ru.yoomoney.tech.dbqueue.settings.QueueLocation;
import ru.yoomoney.tech.dbqueue.settings.QueueSettings;

@FunctionalInterface
public interface QueueRunner {
    @Nonnull
    public QueueProcessingStatus runQueue(@Nonnull QueueConsumer var1);

    public static final class Factory {
        private Factory() {
        }

        public static QueueRunner create(@Nonnull QueueConsumer queueConsumer, @Nonnull QueueShard<?> queueShard, @Nonnull TaskLifecycleListener taskLifecycleListener) {
            Objects.requireNonNull(queueConsumer);
            Objects.requireNonNull(queueShard);
            Objects.requireNonNull(taskLifecycleListener);
            QueueSettings queueSettings = queueConsumer.getQueueConfig().getSettings();
            QueueLocation queueLocation = queueConsumer.getQueueConfig().getLocation();
            QueuePickTaskDao queuePickTaskDao = queueShard.getDatabaseAccessLayer().createQueuePickTaskDao(queueLocation, queueSettings.getFailureSettings());
            TaskPicker taskPicker = new TaskPicker(queueShard, queueLocation, taskLifecycleListener, new MillisTimeProvider.SystemMillisTimeProvider(), queuePickTaskDao);
            TaskResultHandler taskResultHandler = new TaskResultHandler(queueLocation, queueShard, queueSettings.getReenqueueSettings());
            TaskProcessor taskProcessor = new TaskProcessor(queueShard, taskLifecycleListener, new MillisTimeProvider.SystemMillisTimeProvider(), taskResultHandler);
            ProcessingMode processingMode = queueSettings.getProcessingSettings().getProcessingMode();
            switch (processingMode) {
                case SEPARATE_TRANSACTIONS: {
                    return new QueueRunnerInSeparateTransactions(taskPicker, taskProcessor);
                }
                case WRAP_IN_TRANSACTION: {
                    return new QueueRunnerInTransaction(taskPicker, taskProcessor, queueShard);
                }
                case USE_EXTERNAL_EXECUTOR: {
                    Optional<Executor> executor = queueConsumer.getExecutor();
                    return new QueueRunnerInExternalExecutor(taskPicker, taskProcessor, executor.orElseThrow(() -> new IllegalArgumentException("Executor is empty. You must provide QueueConsumer#getExecutor in ProcessingMode#USE_EXTERNAL_EXECUTOR")));
                }
            }
            throw new IllegalStateException("unknown processing mode: " + (Object)((Object)processingMode));
        }
    }
}

