/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.internal.runner;

import edu.umd.cs.findbugs.annotations.SuppressFBWarnings;
import java.util.Objects;
import javax.annotation.Nonnull;
import ru.yoomoney.tech.dbqueue.api.QueueConsumer;
import ru.yoomoney.tech.dbqueue.config.QueueShard;
import ru.yoomoney.tech.dbqueue.internal.processing.QueueProcessingStatus;
import ru.yoomoney.tech.dbqueue.internal.processing.TaskPicker;
import ru.yoomoney.tech.dbqueue.internal.processing.TaskProcessor;
import ru.yoomoney.tech.dbqueue.internal.runner.BaseQueueRunner;
import ru.yoomoney.tech.dbqueue.internal.runner.QueueRunner;

class QueueRunnerInTransaction
implements QueueRunner {
    @Nonnull
    private final QueueShard<?> queueShard;
    private final BaseQueueRunner baseQueueRunner;

    QueueRunnerInTransaction(@Nonnull TaskPicker taskPicker, @Nonnull TaskProcessor taskProcessor, @Nonnull QueueShard<?> queueShard) {
        this.queueShard = Objects.requireNonNull(queueShard);
        this.baseQueueRunner = new BaseQueueRunner(taskPicker, taskProcessor, Runnable::run);
    }

    @Override
    @Nonnull
    @SuppressFBWarnings(value={"NP_NULL_ON_SOME_PATH_FROM_RETURN_VALUE"})
    public QueueProcessingStatus runQueue(@Nonnull QueueConsumer queueConsumer) {
        return Objects.requireNonNull(this.queueShard.getDatabaseAccessLayer().transact(() -> this.baseQueueRunner.runQueue(queueConsumer)));
    }
}

