/*
 * Decompiled with CFR 0.152.
 */
package ru.yoomoney.tech.dbqueue.settings;

import java.util.Collection;
import java.util.Objects;
import java.util.Optional;
import java.util.concurrent.CopyOnWriteArrayList;
import java.util.function.BiConsumer;
import java.util.function.BiFunction;
import javax.annotation.Nonnull;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

abstract class DynamicSetting<T> {
    private static final Logger log = LoggerFactory.getLogger(DynamicSetting.class);
    @Nonnull
    private final Collection<BiConsumer<T, T>> observers = new CopyOnWriteArrayList<BiConsumer<T, T>>();

    DynamicSetting() {
    }

    @Nonnull
    protected abstract String getName();

    @Nonnull
    protected abstract BiFunction<T, T, String> getDiffEvaluator();

    @Nonnull
    protected abstract T getThis();

    protected abstract void copyFields(@Nonnull T var1);

    public final Optional<String> setValue(@Nonnull T newValue) {
        Object oldValue = this.getThis();
        try {
            Objects.requireNonNull(newValue, this.getName() + " must not be null");
            if (newValue.equals(oldValue)) {
                return Optional.empty();
            }
            this.observers.forEach(observer -> observer.accept(oldValue, newValue));
            String diff = this.getDiffEvaluator().apply(oldValue, newValue);
            this.copyFields(newValue);
            return Optional.of(diff);
        }
        catch (RuntimeException exc) {
            log.error("Cannot apply new setting: name={}, oldValue={}, newValue={}", new Object[]{this.getName(), oldValue, newValue, exc});
            return Optional.empty();
        }
    }

    public final void registerObserver(BiConsumer<T, T> observer) {
        this.observers.add(observer);
    }
}

